/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.give;

import com.janboerman.invsee.spigot.InvseePlusPlus;
import com.janboerman.invsee.spigot.addon.give.EnderGiveExecutor;
import com.janboerman.invsee.spigot.addon.give.GiveTabCompleter;
import com.janboerman.invsee.spigot.addon.give.InvGiveExecutor;
import com.janboerman.invsee.spigot.addon.give.ItemQueue;
import com.janboerman.invsee.spigot.addon.give.ItemQueueManager;
import com.janboerman.invsee.spigot.addon.give.JoinListener;
import com.janboerman.invsee.spigot.addon.give.Setup;
import com.janboerman.invsee.spigot.addon.give.common.GiveApi;
import com.janboerman.invsee.spigot.api.InvseeAPI;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GivePlugin
extends JavaPlugin {
    private final ItemQueueManager queueManager = new ItemQueueManager(this);
    private InvseePlusPlus invseePlusPlus;
    private InvseeAPI invseeApi;

    public void onEnable() {
        this.saveDefaultConfig();
        ConfigurationSerialization.registerClass(ItemQueue.class, (String)"ItemQueue");
        this.queueManager.load();
        Setup setup = Setup.setup(this);
        GiveApi giveApi = setup.getGiveApi();
        this.invseePlusPlus = (InvseePlusPlus)this.getServer().getPluginManager().getPlugin("InvSeePlusPlus");
        this.invseeApi = this.invseePlusPlus.getApi();
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(this, this.queueManager), (Plugin)this);
        GiveTabCompleter tabCompleter = new GiveTabCompleter(giveApi, () -> ((InvseePlusPlus)this.invseePlusPlus).itemMaterials());
        PluginCommand invGiveCommand = this.getServer().getPluginCommand("invgive");
        invGiveCommand.setExecutor((CommandExecutor)new InvGiveExecutor(this, this.invseeApi, giveApi, this.queueManager));
        invGiveCommand.setTabCompleter((TabCompleter)tabCompleter);
        PluginCommand enderGiveCommand = this.getServer().getPluginCommand("endergive");
        enderGiveCommand.setExecutor((CommandExecutor)new EnderGiveExecutor(this, this.invseeApi, giveApi, this.queueManager));
        enderGiveCommand.setTabCompleter((TabCompleter)tabCompleter);
    }

    boolean savePartialInventories() {
        return this.getConfig().getBoolean("save-partial-inventories", true);
    }

    boolean queueRemainingItems() {
        return this.getConfig().getBoolean("queue-remaining-items", true);
    }

    boolean offlinePlayerSupport() {
        FileConfiguration config = this.getConfig();
        Object value = config.get("offline-player-support");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String s = (String)value;
            if ("true".equalsIgnoreCase(s)) {
                return true;
            }
            if ("false".equalsIgnoreCase(s)) {
                return false;
            }
            if ("same_as_Invsee++".equalsIgnoreCase(s)) {
                return this.invseePlusPlus.offlinePlayerSupport();
            }
            if ("same_as_InvseeAPI".equalsIgnoreCase(s)) {
                return this.invseeApi.offlinePlayerSupport();
            }
        }
        return true;
    }

    boolean unknownPlayerSupport() {
        FileConfiguration config = this.getConfig();
        Object value = config.get("unknown-player-support");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String s = (String)value;
            if ("true".equalsIgnoreCase(s)) {
                return true;
            }
            if ("false".equalsIgnoreCase(s)) {
                return false;
            }
            if ("same_as_Invsee++".equalsIgnoreCase(s)) {
                return this.invseePlusPlus.unknownPlayerSupport();
            }
            if ("same_as_InvseeAPI".equalsIgnoreCase(s)) {
                return this.invseeApi.unknownPlayerSupport();
            }
        }
        return true;
    }

    boolean bypassExemptInvsee(CommandSender sender) {
        Boolean bypass = this.bypassExempt();
        if (bypass == null) {
            return sender.hasPermission("invseeplusplus.bypass-exempt.invsee");
        }
        return bypass;
    }

    boolean bypassExemptEndersee(CommandSender sender) {
        Boolean bypass = this.bypassExempt();
        if (bypass == null) {
            return sender.hasPermission("invseeplusplus.bypass-exempt.endersee");
        }
        return bypass;
    }

    private Boolean bypassExempt() {
        FileConfiguration config = this.getConfig();
        Object value = config.get("bypass-exempt");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String s = (String)value;
            if ("true".equalsIgnoreCase(s)) {
                return true;
            }
            if ("false".equalsIgnoreCase(s)) {
                return false;
            }
        }
        return null;
    }
}

