/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.give.cmd;

import com.janboerman.invsee.spigot.addon.give.cmd.ArgType;
import com.janboerman.invsee.spigot.addon.give.common.Convert;
import com.janboerman.invsee.spigot.addon.give.common.GiveApi;
import com.janboerman.invsee.spigot.addon.give.common.ItemType;
import com.janboerman.invsee.spigot.api.InvseeAPI;
import com.janboerman.invsee.utils.Compat;
import com.janboerman.invsee.utils.Either;
import com.janboerman.invsee.utils.Pair;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.inventory.ItemStack;

public final class ArgParser {
    private static final List<ArgType> FORMAT_ITEMTYPE_AMOUNT = Compat.listOf((Object[])new ArgType[]{ArgType.TARGET, ArgType.ITEM_TYPE, ArgType.AMOUNT});
    private static final List<ArgType> FORMAT_ITEMTYPE_AMOUNT_NBTTAG = Compat.listOf((Object[])new ArgType[]{ArgType.TARGET, ArgType.ITEM_TYPE, ArgType.AMOUNT, ArgType.NBT_TAG});
    private static final List<ArgType> FORMAT_ITEMTYPE = Compat.listOf((Object[])new ArgType[]{ArgType.TARGET, ArgType.ITEM_TYPE});

    private ArgParser() {
    }

    public static Optional<List<ArgType>> determineFormat(String[] arguments) {
        List<ArgType> format;
        if (arguments.length < 2) {
            return Optional.empty();
        }
        String lastArg = arguments[arguments.length - 1];
        try {
            Integer.parseInt(lastArg);
            format = FORMAT_ITEMTYPE_AMOUNT;
        }
        catch (NumberFormatException e) {
            format = lastArg.endsWith("}") ? FORMAT_ITEMTYPE_AMOUNT_NBTTAG : FORMAT_ITEMTYPE;
        }
        return Optional.of(format);
    }

    public static Map<ArgType, String> splitArguments(List<ArgType> format, String[] args) {
        EnumMap<ArgType, String> result = new EnumMap<ArgType, String>(ArgType.class);
        result.put(ArgType.TARGET, args[0]);
        if (FORMAT_ITEMTYPE.equals(format)) {
            result.put(ArgType.ITEM_TYPE, args[1]);
        } else if (FORMAT_ITEMTYPE_AMOUNT.equals(format)) {
            String countString = args[args.length - 1];
            List itemTypeString = Compat.listOf((Object[])args).subList(1, args.length - 1);
            result.put(ArgType.AMOUNT, countString);
            result.put(ArgType.ITEM_TYPE, String.join((CharSequence)" ", itemTypeString));
        } else if (FORMAT_ITEMTYPE_AMOUNT_NBTTAG.equals(format)) {
            result.put(ArgType.ITEM_TYPE, args[1]);
            result.put(ArgType.AMOUNT, args[2]);
            result.put(ArgType.NBT_TAG, String.join((CharSequence)" ", Compat.listOf((Object[])args).subList(3, args.length)));
        } else {
            throw new IllegalArgumentException("Unexpected format: " + format);
        }
        return result;
    }

    public static Pair<CompletableFuture<Optional<UUID>>, CompletableFuture<Optional<String>>> parseTarget(InvseeAPI invseeApi, String target) {
        CompletableFuture userNameFuture;
        CompletableFuture uuidFuture;
        Either<UUID, String> eitherPlayer = Convert.convertPlayer(target);
        if (eitherPlayer.isLeft()) {
            UUID uuid = (UUID)eitherPlayer.getLeft();
            uuidFuture = CompletableFuture.completedFuture(Optional.of(uuid));
            userNameFuture = invseeApi.fetchUserName(uuid);
        } else {
            assert (eitherPlayer.isRight());
            String userName = (String)eitherPlayer.getRight();
            userNameFuture = CompletableFuture.completedFuture(Optional.of(userName));
            uuidFuture = invseeApi.fetchUniqueId(userName);
        }
        return new Pair((Object)uuidFuture, (Object)userNameFuture);
    }

    public static Either<String, ItemStack> parseItem(GiveApi giveApi, Map<ArgType, String> arguments) {
        try {
            return ArgParser.getAmount(arguments).flatMap(amount -> ArgParser.getItemType(arguments, giveApi).flatMap(itemType -> itemType.toItemStack((int)amount))).flatMap(itemStack -> ArgParser.applyTag(arguments, giveApi, itemStack));
        }
        catch (IllegalArgumentException e) {
            return Either.left((Object)e.getMessage());
        }
    }

    private static Either<String, Integer> getAmount(Map<ArgType, String> arguments) {
        String amountString = arguments.get((Object)ArgType.AMOUNT);
        if (amountString == null) {
            return Either.right((Object)1);
        }
        return Convert.convertAmount(amountString);
    }

    private static Either<String, ItemType> getItemType(Map<ArgType, String> arguments, GiveApi giveApi) {
        return giveApi.parseItemType(arguments.get((Object)ArgType.ITEM_TYPE));
    }

    private static Either<String, ItemStack> applyTag(Map<ArgType, String> arguments, GiveApi giveApi, ItemStack stack) {
        return Either.right((Object)giveApi.applyTag(stack, arguments.get((Object)ArgType.NBT_TAG)));
    }
}

