/*
 * Decompiled with CFR 0.152.
 */
package me.nullicorn.nedit;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;
import me.nullicorn.nedit.exception.NBTParseException;
import me.nullicorn.nedit.type.NBTCompound;
import me.nullicorn.nedit.type.NBTList;
import me.nullicorn.nedit.type.TagType;

public class NBTInputStream
extends DataInputStream {
    protected final boolean internNames;
    protected final boolean internValues;

    public NBTInputStream(InputStream inputStream) {
        this(inputStream, false, false);
    }

    public NBTInputStream(InputStream inputStream, boolean internNames, boolean internValues) {
        super(inputStream);
        this.internNames = internNames;
        this.internValues = internValues;
    }

    public NBTCompound readFully() throws IOException {
        this.gunzipIfNecessary();
        TagType rootType = this.readTagId();
        if (rootType == TagType.END) {
            return new NBTCompound();
        }
        if (rootType != TagType.COMPOUND) {
            throw new IOException("Expected COMPOUND at NBT root, but got " + (Object)((Object)rootType));
        }
        this.readString();
        return this.readCompound();
    }

    public NBTCompound readCompound() throws IOException {
        NBTCompound result = new NBTCompound();
        boolean reachedEnd = false;
        while (!reachedEnd) {
            TagType entryType = this.readTagId();
            if (entryType == null) {
                throw new NBTParseException("Unknown tag ID for TAG_Compound");
            }
            if (entryType == TagType.END) {
                reachedEnd = true;
                continue;
            }
            String entryName = this.readString(this.internNames);
            Object entryValue = this.readValue(entryType);
            result.put(entryName, entryValue);
        }
        return result;
    }

    public NBTList readList() throws IOException {
        TagType typeOfContents = this.readTagId();
        if (typeOfContents == null) {
            throw new NBTParseException("Unknown tag ID for TAG_List");
        }
        int length = this.readInt();
        if (length <= 0) {
            return new NBTList(typeOfContents);
        }
        NBTList result = new NBTList(typeOfContents);
        for (int i = 0; i < length; ++i) {
            result.add(this.readValue(typeOfContents));
        }
        return result;
    }

    public String readString() throws IOException {
        return this.readString(false);
    }

    public String readString(boolean intern) throws IOException {
        String utf = this.readUTF();
        if (intern) {
            return utf.intern();
        }
        return utf;
    }

    public long[] readLongArray() throws IOException {
        int length = this.readInt();
        if (length < 0) {
            throw new NBTParseException(new NegativeArraySizeException("TAG_Long_Array was prefixed with a negative length"));
        }
        if (length == 0) {
            return new long[0];
        }
        byte[] bytes = new byte[length * 8];
        this.readFully(bytes);
        int byteIndex = 0;
        long[] longArray = new long[length];
        int i = 0;
        while (i < length) {
            long element = 0L;
            int bitOffset = 56;
            int b = 0;
            while (b < 8) {
                element |= (long)(bytes[byteIndex + b] & 0xFF) << bitOffset;
                ++b;
                bitOffset -= 8;
            }
            longArray[i] = element;
            ++i;
            byteIndex += 8;
        }
        return longArray;
    }

    public int[] readIntArray() throws IOException {
        int length = this.readInt();
        if (length < 0) {
            throw new NBTParseException(new NegativeArraySizeException("TAG_Int_Array was prefixed with a negative length"));
        }
        byte[] bytes = new byte[length * 4];
        this.readFully(bytes);
        int byteIndex = 0;
        int[] intArray = new int[length];
        int i = 0;
        while (i < length) {
            int element = 0;
            int bitOffset = 24;
            int b = 0;
            while (b < 4) {
                element |= (bytes[byteIndex + b] & 0xFF) << bitOffset;
                ++b;
                bitOffset -= 8;
            }
            intArray[i] = element;
            ++i;
            byteIndex += 4;
        }
        return intArray;
    }

    public byte[] readByteArray() throws IOException {
        int length = this.readInt();
        if (length < 0) {
            throw new NBTParseException(new NegativeArraySizeException("TAG_Byte_Array was prefixed with a negative length"));
        }
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return bytes;
    }

    public TagType readTagId() throws IOException {
        return TagType.fromId(this.read());
    }

    public Object readValue(TagType tagType) throws IOException {
        switch (tagType) {
            case BYTE: {
                return this.readByte();
            }
            case SHORT: {
                return this.readShort();
            }
            case INT: {
                return this.readInt();
            }
            case LONG: {
                return this.readLong();
            }
            case FLOAT: {
                return Float.valueOf(this.readFloat());
            }
            case DOUBLE: {
                return this.readDouble();
            }
            case BYTE_ARRAY: {
                return this.readByteArray();
            }
            case STRING: {
                return this.readString(this.internValues);
            }
            case LIST: {
                return this.readList();
            }
            case COMPOUND: {
                return this.readCompound();
            }
            case INT_ARRAY: {
                return this.readIntArray();
            }
            case LONG_ARRAY: {
                return this.readLongArray();
            }
        }
        return null;
    }

    public synchronized void gunzipIfNecessary() throws IOException {
        this.in = new PushbackInputStream(this.in, 2);
        byte byte1 = (byte)this.read();
        byte byte2 = (byte)this.read();
        ((PushbackInputStream)this.in).unread(new byte[]{byte1, byte2});
        if (byte1 == 31 && byte2 == -117) {
            this.in = new GZIPInputStream(this.in);
        }
    }
}

