/*
 * Decompiled with CFR 0.152.
 */
package me.nullicorn.nedit;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import me.nullicorn.nedit.NBTInputStream;
import me.nullicorn.nedit.type.NBTCompound;

public final class NBTReader {
    public static NBTCompound readBase64(String base64) throws IOException {
        return NBTReader.readBase64(base64, false, false);
    }

    public static NBTCompound readBase64(String base64, boolean internNames, boolean internValues) throws IOException {
        ByteArrayInputStream b64In = new ByteArrayInputStream(Base64.getDecoder().decode(base64));
        return NBTReader.read(b64In, internNames, internValues);
    }

    public static NBTCompound readFile(File nbtFile) throws IOException {
        return NBTReader.readFile(nbtFile, false, false);
    }

    public static NBTCompound readFile(File nbtFile, boolean internNames, boolean internValues) throws IOException {
        if (!(nbtFile.exists() && nbtFile.isFile() && nbtFile.canRead())) {
            throw new FileNotFoundException("NBT file not found or unable to be read");
        }
        try (FileInputStream fileIn = new FileInputStream(nbtFile);){
            NBTCompound nBTCompound = NBTReader.read(new FileInputStream(nbtFile), internNames, internValues);
            return nBTCompound;
        }
    }

    public static NBTCompound read(InputStream inputStream) throws IOException {
        return NBTReader.read(inputStream, false, false);
    }

    public static NBTCompound read(InputStream inputStream, boolean internNames, boolean internValues) throws IOException {
        return new NBTInputStream(inputStream, internNames, internValues).readFully();
    }

    private NBTReader() {
        throw new UnsupportedOperationException("NBTReader should not be instantiated");
    }
}

