/*
 * Decompiled with CFR 0.152.
 */
package me.nullicorn.nedit.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import me.nullicorn.nedit.filter.FilterMode;
import me.nullicorn.nedit.filter.FilteredTag;

public class NBTFilter
implements Iterable<FilteredTag> {
    private final FilterMode mode;
    private final Set<FilteredTag> filteredTags;

    public static NBTFilter with(String ... includedTags) {
        NBTFilter filter = new NBTFilter(FilterMode.INCLUDE);
        filter.addTags(includedTags);
        return filter;
    }

    public static NBTFilter without(String ... excludedTags) {
        NBTFilter filter = new NBTFilter(FilterMode.EXCLUDE);
        filter.addTags(excludedTags);
        return filter;
    }

    public NBTFilter(FilterMode mode) {
        this.mode = mode;
        this.filteredTags = new HashSet<FilteredTag>();
    }

    public FilterMode getMode() {
        return this.mode;
    }

    public Set<FilteredTag> getFilteredTags() {
        return new HashSet<FilteredTag>(this.filteredTags);
    }

    public NBTFilter subFilter(FilteredTag base, int depth) {
        String[] baseTokens = base.getTokens();
        if (depth > baseTokens.length) {
            throw new IllegalArgumentException("Base tag \"" + base + "\" does not reach depth " + depth);
        }
        NBTFilter sub = new NBTFilter(this.mode);
        for (FilteredTag tag : this.filteredTags) {
            if (!base.isExtendedBy(tag, depth)) continue;
            sub.filteredTags.add(tag);
        }
        if (depth < baseTokens.length) {
            sub.filteredTags.add(base);
        }
        return sub;
    }

    public boolean isEmpty() {
        return this.filteredTags.isEmpty();
    }

    @Override
    public Iterator<FilteredTag> iterator() {
        return this.filteredTags.iterator();
    }

    public void addTags(String ... tagNames) {
        Objects.requireNonNull(tagNames, "tagNames array cannot be null");
        for (String rawName : tagNames) {
            Objects.requireNonNull(rawName, "tagNames array cannot contain null names");
            FilteredTag tag = new FilteredTag(rawName);
            boolean shouldAddTag = true;
            Iterator<FilteredTag> existingTags = this.filteredTags.iterator();
            while (existingTags.hasNext()) {
                FilteredTag existingTag = existingTags.next();
                if (existingTag.equals(tag)) {
                    shouldAddTag = false;
                    break;
                }
                if (tag.isExtendedBy(existingTag)) {
                    existingTags.remove();
                    continue;
                }
                if (!existingTag.isExtendedBy(tag)) continue;
                existingTags.remove();
                break;
            }
            if (!shouldAddTag) continue;
            this.filteredTags.add(tag);
        }
    }

    public void removeFilteredTags(String ... tagNames) {
        Objects.requireNonNull(tagNames, "tagNames array cannot be null");
        for (String name : tagNames) {
            Objects.requireNonNull(name, "tagNames array cannot contain null names");
            this.filteredTags.removeIf(tag -> tag.getName().equals(name));
        }
    }
}

