/*
 * Decompiled with CFR 0.152.
 */
package me.nullicorn.nedit.type;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.nullicorn.nedit.type.NBTCompound;
import me.nullicorn.nedit.type.TagType;

public class NBTList
extends AbstractList<Object> {
    private final List<Object> decorated = new ArrayList<Object>();
    private final TagType contentType;

    public NBTList(TagType type) {
        this.contentType = type == null ? TagType.END : type;
    }

    public TagType getContentType() {
        return this.contentType;
    }

    @Override
    public Object set(int index, Object tag) {
        this.checkType(tag);
        return this.decorated.set(index, tag);
    }

    @Override
    public boolean add(Object tag) {
        this.checkType(tag);
        return this.decorated.add(tag);
    }

    @Override
    public void add(int index, Object tag) {
        this.checkType(tag);
        this.decorated.add(index, tag);
    }

    @Override
    public boolean addAll(Collection<?> tags) {
        Objects.requireNonNull(tags, "tags collection cannot be null");
        tags.forEach(this::checkType);
        return this.decorated.addAll(tags);
    }

    @Override
    public boolean addAll(int index, Collection<?> tags) {
        Objects.requireNonNull(tags, "tags collection cannot be null");
        tags.forEach(this::checkType);
        return this.decorated.addAll(index, tags);
    }

    @Override
    public Object get(int index) {
        return this.decorated.get(index);
    }

    public Byte getByte(int index) {
        this.checkGetType(TagType.BYTE);
        return (Byte)this.get(index);
    }

    public Short getShort(int index) {
        this.checkGetType(TagType.SHORT);
        return (Short)this.get(index);
    }

    public Integer getInt(int index) {
        this.checkGetType(TagType.INT);
        return (Integer)this.get(index);
    }

    public Long getLong(int index) {
        this.checkGetType(TagType.LONG);
        return (Long)this.get(index);
    }

    public Float getFloat(int index) {
        this.checkGetType(TagType.FLOAT);
        return (Float)this.get(index);
    }

    public Double getDouble(int index) {
        this.checkGetType(TagType.DOUBLE);
        return (Double)this.get(index);
    }

    public String getString(int index) {
        this.checkGetType(TagType.STRING);
        return (String)this.get(index);
    }

    public byte[] getByteArray(int index) {
        this.checkGetType(TagType.BYTE_ARRAY);
        return (byte[])this.get(index);
    }

    public int[] getIntArray(int index) {
        this.checkGetType(TagType.INT_ARRAY);
        return (int[])this.get(index);
    }

    public long[] getLongArray(int index) {
        this.checkGetType(TagType.LONG_ARRAY);
        return (long[])this.get(index);
    }

    public NBTList getList(int index) {
        this.checkGetType(TagType.LIST);
        return (NBTList)this.get(index);
    }

    public NBTCompound getCompound(int index) {
        this.checkGetType(TagType.COMPOUND);
        return (NBTCompound)this.get(index);
    }

    public void forEachByte(Consumer<Byte> action) {
        this.forEachOfType(action, TagType.BYTE);
    }

    public void forEachShort(Consumer<Short> action) {
        this.forEachOfType(action, TagType.SHORT);
    }

    public void forEachInt(Consumer<Integer> action) {
        this.forEachOfType(action, TagType.INT);
    }

    public void forEachLong(Consumer<Long> action) {
        this.forEachOfType(action, TagType.LONG);
    }

    public void forEachFloat(Consumer<Float> action) {
        this.forEachOfType(action, TagType.FLOAT);
    }

    public void forEachDouble(Consumer<Double> action) {
        this.forEachOfType(action, TagType.DOUBLE);
    }

    public void forEachString(Consumer<String> action) {
        this.forEachOfType(action, TagType.STRING);
    }

    public void forEachByteArray(Consumer<byte[]> action) {
        this.forEachOfType(action, TagType.BYTE_ARRAY);
    }

    public void forEachIntArray(Consumer<int[]> action) {
        this.forEachOfType(action, TagType.INT_ARRAY);
    }

    public void forEachLongArray(Consumer<long[]> action) {
        this.forEachOfType(action, TagType.LIST);
    }

    public void forEachList(Consumer<NBTList> action) {
        this.forEachOfType(action, TagType.LIST);
    }

    public void forEachCompound(Consumer<NBTCompound> action) {
        this.forEachOfType(action, TagType.COMPOUND);
    }

    private <T> void forEachOfType(Consumer<T> action, TagType type) {
        this.checkGetType(type);
        this.forEach((Consumer<? super Object>)((Consumer<Object>)element -> action.accept(element)));
    }

    private void checkGetType(TagType attemptedType) {
        if (attemptedType != this.contentType) {
            throw new IllegalStateException("Cannot get " + (Object)((Object)attemptedType) + " from a list of " + this.contentType.toString() + "s");
        }
    }

    private void checkType(Object tag) {
        if (this.contentType == TagType.END) {
            throw new IllegalStateException("Cannot add tags to a list with content-type TAG_End");
        }
        Objects.requireNonNull(tag);
        TagType actualType = TagType.fromObject(tag);
        if (actualType != this.contentType) {
            throw new IllegalArgumentException("Type mismatch; cannot put " + (Object)((Object)actualType) + " into a list of " + (Object)((Object)this.contentType) + ": " + tag);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NBTList objects = (NBTList)o;
        if (this.contentType != objects.contentType) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.contentType});
    }

    @Override
    public int indexOf(Object o) {
        return this.decorated.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.decorated.lastIndexOf(o);
    }

    @Override
    public boolean contains(Object o) {
        return this.decorated.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.decorated.containsAll(c);
    }

    @Override
    public int size() {
        return this.decorated.size();
    }

    @Override
    public boolean isEmpty() {
        return this.decorated.isEmpty();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.decorated.iterator();
    }

    @Override
    public Spliterator<Object> spliterator() {
        return this.decorated.spliterator();
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.decorated.subList(fromIndex, toIndex);
    }

    @Override
    public Stream<Object> stream() {
        return this.decorated.stream();
    }

    @Override
    public Stream<Object> parallelStream() {
        return this.decorated.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super Object> action) {
        this.decorated.forEach(action);
    }

    @Override
    public void sort(Comparator<? super Object> c) {
        this.decorated.sort(c);
    }

    @Override
    public Object remove(int index) {
        return this.decorated.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.decorated.remove(o);
    }

    @Override
    public boolean removeIf(Predicate<? super Object> filter) {
        return this.decorated.removeIf(filter);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.decorated.removeAll(c);
    }

    @Override
    public void clear() {
        this.decorated.clear();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.decorated.toArray(a);
    }

    @Override
    public Object[] toArray() {
        return this.decorated.toArray();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.decorated.retainAll(c);
    }
}

