/*
 * Decompiled with CFR 0.152.
 */
package me.nullicorn.nedit.type;

import java.util.Arrays;
import java.util.Comparator;
import me.nullicorn.nedit.type.NBTCompound;
import me.nullicorn.nedit.type.NBTList;

public enum TagType {
    END(0, null),
    BYTE(1, Byte.class),
    SHORT(2, Short.class),
    INT(3, Integer.class),
    LONG(4, Long.class),
    FLOAT(5, Float.class),
    DOUBLE(6, Double.class),
    BYTE_ARRAY(7, byte[].class),
    STRING(8, String.class),
    LIST(9, NBTList.class),
    COMPOUND(10, NBTCompound.class),
    INT_ARRAY(11, int[].class),
    LONG_ARRAY(12, long[].class);

    private static final TagType[] values;
    private final int id;
    private final Class<?> runtimeType;

    private TagType(int id, Class<?> runtimeType) {
        this.id = id;
        this.runtimeType = runtimeType;
    }

    public int getId() {
        return this.id;
    }

    public Class<?> getRuntimeType() {
        return this.runtimeType;
    }

    @Deprecated
    public Class<?> getClazz() {
        return this.getRuntimeType();
    }

    public static TagType fromId(int id) {
        if (id < 0 || id >= values.length) {
            return null;
        }
        return values[id];
    }

    public static TagType fromObject(Object obj) {
        if (obj instanceof Byte) {
            return BYTE;
        }
        if (obj instanceof Short) {
            return SHORT;
        }
        if (obj instanceof Integer) {
            return INT;
        }
        if (obj instanceof Long) {
            return LONG;
        }
        if (obj instanceof Float) {
            return FLOAT;
        }
        if (obj instanceof Double) {
            return DOUBLE;
        }
        if (obj instanceof byte[]) {
            return BYTE_ARRAY;
        }
        if (obj instanceof String) {
            return STRING;
        }
        if (obj instanceof NBTList) {
            return LIST;
        }
        if (obj instanceof NBTCompound) {
            return COMPOUND;
        }
        if (obj instanceof int[]) {
            return INT_ARRAY;
        }
        if (obj instanceof long[]) {
            return LONG_ARRAY;
        }
        if (obj == null) {
            return END;
        }
        throw new IllegalArgumentException(obj.getClass().getSimpleName() + " has no NBT type");
    }

    static {
        values = TagType.values();
        Arrays.sort(values, Comparator.comparingInt(TagType::getId));
    }
}

