/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.mojangapi;

import com.janboerman.invsee.jsonsimple.JSONObject;
import com.janboerman.invsee.mojangapi.ResponseUtils;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ElectroidAPI {
    private final HttpClient httpClient;

    public ElectroidAPI(Executor asyncExecutor) {
        this.httpClient = HttpClient.newBuilder().executor(asyncExecutor).build();
    }

    @Deprecated
    public ElectroidAPI(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Deprecated
    public ElectroidAPI() {
        this(HttpClient.newHttpClient());
    }

    public CompletableFuture<Optional<UUID>> lookupUniqueId(String userName) {
        CompletableFuture<HttpResponse<InputStream>> future = this.httpClient.sendAsync(HttpRequest.newBuilder(URI.create("https://api.ashcon.app/mojang/v2/user/" + userName)).header("Accept", "application/json").header("User-Agent", "InvSee++/ElectroidAPI").timeout(Duration.ofSeconds(5L)).build(), HttpResponse.BodyHandlers.ofInputStream());
        return future.thenApply(response -> {
            if (response.statusCode() == 200) {
                JSONObject json = ResponseUtils.readJSONObject(response);
                String uuid = (String)json.get("uuid");
                return Optional.of(UUID.fromString(uuid));
            }
            if (response.statusCode() == 204) {
                return Optional.empty();
            }
            throw new RuntimeException("Unexpected response from Electroid mojang api, status code=" + response.statusCode() + ".");
        });
    }

    public CompletableFuture<Optional<String>> lookupUserName(UUID uniqueId) {
        CompletableFuture<HttpResponse<InputStream>> future = this.httpClient.sendAsync(HttpRequest.newBuilder(URI.create("https://api.ashcon.app/mojang/v2/user/" + uniqueId.toString())).header("Accept", "application/json").header("User-Agent", "InvSee++/ElectroidAPI").timeout(Duration.ofSeconds(5L)).build(), HttpResponse.BodyHandlers.ofInputStream());
        return future.thenApply(response -> {
            if (response.statusCode() == 200) {
                JSONObject json = ResponseUtils.readJSONObject(response);
                String userName = (String)json.get("username");
                return Optional.of(userName);
            }
            if (response.statusCode() == 204) {
                return Optional.empty();
            }
            throw new RuntimeException("Unexpected response from Electroid mojang api, status code=" + response.statusCode() + ".");
        });
    }
}

