/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.mojangapi;

import com.janboerman.invsee.jsonsimple.JSONObject;
import com.janboerman.invsee.mojangapi.ResponseUtils;
import com.janboerman.invsee.utils.UUIDHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MojangAPI {
    private final HttpClient httpClient;

    public MojangAPI(Executor asyncExecutor) {
        this.httpClient = HttpClient.newBuilder().executor(asyncExecutor).build();
    }

    @Deprecated
    public MojangAPI(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient);
    }

    @Deprecated
    public MojangAPI() {
        this(HttpClient.newHttpClient());
    }

    public CompletableFuture<Optional<UUID>> lookupUniqueId(String userName) {
        CompletableFuture<HttpResponse<InputStream>> future = this.httpClient.sendAsync(HttpRequest.newBuilder(URI.create("https://api.mojang.com/users/profiles/minecraft/" + userName)).header("Accept", "application/json").header("User-Agent", "InvSee++/MojangAPI").timeout(Duration.ofSeconds(5L)).build(), HttpResponse.BodyHandlers.ofInputStream());
        return future.thenApply(response -> {
            int statusCode = response.statusCode();
            if (statusCode == 200) {
                JSONObject json = ResponseUtils.readJSONObject(response);
                String id = (String)json.get("id");
                UUID uuid = UUIDHelper.dashed(id);
                return Optional.of(uuid);
            }
            return MojangAPI.handleNotOk(response);
        });
    }

    public CompletableFuture<Optional<String>> lookupUserName(UUID uniqueId) {
        CompletableFuture<HttpResponse<InputStream>> future = this.httpClient.sendAsync(HttpRequest.newBuilder(URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + UUIDHelper.unDashed(uniqueId))).header("Accept", "application/json").header("User-Agent", "InvSee++/MojangAPI").timeout(Duration.ofSeconds(5L)).build(), HttpResponse.BodyHandlers.ofInputStream());
        return future.thenApply(response -> {
            int statusCode = response.statusCode();
            if (statusCode == 200) {
                JSONObject profileJson = ResponseUtils.readJSONObject(response);
                String userName = (String)profileJson.get("name");
                return Optional.of(userName);
            }
            return MojangAPI.handleNotOk(response);
        });
    }

    private static <T> Optional<T> handleNotOk(HttpResponse<InputStream> response) {
        int statusCode = response.statusCode();
        if (statusCode == 204) {
            return MojangAPI.handleNoContent(response);
        }
        if (statusCode == 400) {
            return MojangAPI.handleBadRequest(response);
        }
        if (statusCode == 429) {
            return MojangAPI.handleTooManyRequests(response);
        }
        return MojangAPI.handleUnknownStatusCode(response);
    }

    private static <T> Optional<T> handleNoContent(HttpResponse<InputStream> response) {
        return Optional.empty();
    }

    private static <T> Optional<T> handleBadRequest(HttpResponse<InputStream> response) {
        JSONObject jsonObject = ResponseUtils.readJSONObject(response);
        String error = (String)jsonObject.get("error");
        String errorMessage = (String)jsonObject.get("errorMessage");
        throw new RuntimeException("We sent a bad request to Mojang. We got a(n) " + error + " with the following message: " + errorMessage);
    }

    private static <T> Optional<T> handleTooManyRequests(HttpResponse<InputStream> response) {
        try {
            InputStream inputStream = response.body();
            try {
                byte[] bytes = inputStream.readAllBytes();
                Charset charset = ResponseUtils.charsetFromHeaders(response.headers());
                String errorMessage = new String(bytes, charset);
                throw new RuntimeException("We were rate limited by Mojang. Error message: " + errorMessage);
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception occurred when processing 429 (rate limited) response.", e);
        }
    }

    private static <T> Optional<T> handleUnknownStatusCode(HttpResponse<InputStream> response) {
        throw new RuntimeException("Unexpected status code from Mojang API: " + response.statusCode());
    }
}

