/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Compat {
    private Compat() {
    }

    static void checkFromToIndex(int fromIndex, int toIndex, int size) {
        Objects.checkFromToIndex(fromIndex, toIndex, size);
    }

    static void checkIndex(int index, int size) {
        Objects.checkIndex(index, size);
    }

    public static <K, V> Map.Entry<K, V> mapEntry(K key, V value) {
        return Map.entry(key, value);
    }

    public static <K, V> Map<K, V> mapOfEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        return Map.ofEntries(entries);
    }

    public static Stream<String> lines(String string) {
        return string.lines();
    }

    public static <T> List<T> listCopy(Collection<T> coll) {
        return List.copyOf(coll);
    }

    public static <T> List<T> listOf(T ... items) {
        return List.of(items);
    }

    public static <T> List<T> emptyList() {
        return List.of();
    }

    public static <T> List<T> singletonList(T item) {
        return List.of(item);
    }

    public static <T> void ifPresentOrElse(Optional<T> optional, Consumer<? super T> action, Runnable emptyAction) {
        optional.ifPresentOrElse(action, emptyAction);
    }

    public static <K, V> Map<K, V> emptyMap() {
        return Map.of();
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        return inputStream.readAllBytes();
    }
}

