/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.glowstone;

import com.flowpowered.network.Message;
import com.flowpowered.network.MessageHandler;
import com.flowpowered.network.session.Session;
import com.janboerman.invsee.glowstone.EnderInventoryView;
import com.janboerman.invsee.glowstone.InvseeImpl;
import com.janboerman.invsee.glowstone.MainInventoryView;
import com.janboerman.invsee.spigot.api.SpectatorInventoryView;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.glowstone.entity.GlowPlayer;
import net.glowstone.net.GlowSession;
import net.glowstone.net.handler.play.inv.WindowClickHandler;
import net.glowstone.net.message.play.inv.WindowClickMessage;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class DecoratedWindowClickHandler
implements MessageHandler<GlowSession, WindowClickMessage> {
    private final MessageHandler<GlowSession, WindowClickMessage> delegate;

    public DecoratedWindowClickHandler() {
        this((MessageHandler<GlowSession, WindowClickMessage>)new WindowClickHandler());
    }

    DecoratedWindowClickHandler(MessageHandler<GlowSession, WindowClickMessage> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public void handle(GlowSession glowSession, WindowClickMessage windowClickMessage) {
        GlowPlayer player = glowSession.getPlayer();
        InventoryView openInventory = player.getOpenInventory();
        SpectatorInventoryView view = null;
        List<ItemStack> before = null;
        List<ItemStack> after = null;
        if (openInventory instanceof SpectatorInventoryView) {
            view = (SpectatorInventoryView)openInventory;
            before = Arrays.stream(view.getTopInventory().getContents()).map(DecoratedWindowClickHandler::cloneItemStack).collect(Collectors.toList());
        }
        this.delegate.handle((Session)glowSession, (Message)windowClickMessage);
        if (openInventory instanceof SpectatorInventoryView) {
            after = Arrays.stream(view.getTopInventory().getContents()).map(DecoratedWindowClickHandler::cloneItemStack).collect(Collectors.toList());
        }
        if (view instanceof MainInventoryView) {
            ((MainInventoryView)view).onClick(before, after);
        } else if (view instanceof EnderInventoryView) {
            ((EnderInventoryView)view).onClick(before, after);
        }
    }

    private static ItemStack cloneItemStack(ItemStack stack) {
        return stack == null ? InvseeImpl.EMPTY_STACK : stack.clone();
    }
}

