/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.glowstone;

import com.janboerman.invsee.glowstone.GlowstoneHacks;
import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventory;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.internal.inventory.ShallowCopy;
import com.janboerman.invsee.utils.UUIDHelper;
import java.util.UUID;
import java.util.function.Consumer;
import net.glowstone.entity.GlowHumanEntity;
import net.glowstone.inventory.GlowInventory;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

class EnderInventory
extends GlowInventory
implements EnderSpectatorInventory,
ShallowCopy<EnderInventory> {
    final UUID targetPlayerUuid;
    final String targetPlayerName;
    final CreationOptions<EnderChestSlot> creationOptions;

    public EnderInventory(GlowHumanEntity target, CreationOptions<EnderChestSlot> creationOptions) {
        super(null, InventoryType.CHEST, target.getEnderChest().getSize(), creationOptions.getTitle().titleFor(Target.byGameProfile(target.getUniqueId(), target.getName())));
        this.targetPlayerUuid = UUIDHelper.copy(target.getUniqueId());
        this.targetPlayerName = target.getName();
        this.creationOptions = creationOptions;
        this.setMaxStackSize(this.defaultMaxStack());
        GlowstoneHacks.setSlots(this, GlowstoneHacks.getSlots(target.getEnderChest()));
    }

    @Override
    public String getSpectatedPlayerName() {
        return this.targetPlayerName;
    }

    @Override
    public UUID getSpectatedPlayerId() {
        return this.targetPlayerUuid;
    }

    @Override
    public Mirror<EnderChestSlot> getMirror() {
        return this.creationOptions.getMirror();
    }

    @Override
    public CreationOptions<EnderChestSlot> getCreationOptions() {
        return this.creationOptions.clone();
    }

    @Override
    public int defaultMaxStack() {
        return 64;
    }

    @Override
    public void shallowCopyFrom(EnderInventory from) {
        GlowstoneHacks.setSlots(this, GlowstoneHacks.getSlots(from));
    }

    @Override
    public void setContents(EnderSpectatorInventory newContents) {
        super.setContents(newContents.getContents());
    }

    @Override
    public ItemStack[] getStorageContents() {
        return super.getContents();
    }

    @Override
    public void setStorageContents(ItemStack[] contents) {
        super.setContents(contents);
    }

    public void forEach(Consumer<? super ItemStack> action) {
        this.getSlots().forEach((? super T slot) -> action.accept(slot.getItem()));
    }

    public boolean containsAtLeast(ItemStack stack, int amount) {
        if (amount <= 0) {
            return true;
        }
        if (stack == null) {
            return false;
        }
        int encountered = 0;
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (item == null || !item.isSimilar(stack) || (encountered += item.getAmount()) < amount) continue;
            return true;
        }
        return false;
    }
}

