/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.glowstone;

import com.janboerman.invsee.glowstone.BukkitInventoryView;
import com.janboerman.invsee.glowstone.MainInventory;
import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.MainSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.logging.Difference;
import com.janboerman.invsee.spigot.api.logging.DifferenceTracker;
import com.janboerman.invsee.spigot.api.logging.LogOptions;
import com.janboerman.invsee.spigot.api.logging.LogOutput;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

class MainInventoryView
extends BukkitInventoryView<PlayerInventorySlot>
implements MainSpectatorInventoryView {
    private final HumanEntity spectator;
    private final MainInventory top;
    private final PlayerInventory bottom;
    private final ItemStack inaccessiblePlaceholder;
    private DifferenceTracker diffTracker;
    InventoryOpenEvent openEvent;

    MainInventoryView(HumanEntity spectator, MainInventory top, CreationOptions<PlayerInventorySlot> creationOptions) {
        super(creationOptions);
        this.spectator = spectator;
        this.bottom = spectator.getInventory();
        this.top = top;
        Target target = Target.byGameProfile(top.getSpectatedPlayerId(), top.getSpectatedPlayerName());
        LogOptions logOptions = creationOptions.getLogOptions();
        Plugin plugin = creationOptions.getPlugin();
        if (!LogOptions.isEmpty(logOptions)) {
            this.diffTracker = new DifferenceTracker(LogOutput.make(plugin, spectator.getUniqueId(), spectator.getName(), target, logOptions), logOptions.getGranularity());
            this.diffTracker.onOpen();
        }
        this.inaccessiblePlaceholder = creationOptions.getPlaceholderPalette().inaccessible();
    }

    @Override
    public MainInventory getTopInventory() {
        return this.top;
    }

    public PlayerInventory getBottomInventory() {
        return this.bottom;
    }

    public HumanEntity getPlayer() {
        return this.spectator;
    }

    public ItemStack getItem(int slot) {
        MainInventory top;
        if (0 <= slot && slot < (top = this.getTopInventory()).getSize()) {
            PlayerInventorySlot piSlot = (PlayerInventorySlot)((Object)this.getMirror().getSlot(slot));
            return piSlot == null ? this.inaccessiblePlaceholder : top.getItem(piSlot.defaultIndex());
        }
        return super.getItem(slot);
    }

    public void setItem(int slot, ItemStack item) {
        MainInventory top;
        if (0 <= slot && slot < (top = this.getTopInventory()).getSize()) {
            PlayerInventorySlot piSlot = (PlayerInventorySlot)((Object)this.getMirror().getSlot(slot));
            if (piSlot != null) {
                top.setItem(piSlot.defaultIndex(), item);
            }
        } else {
            super.setItem(slot, item);
        }
    }

    @Override
    @Nullable
    public Difference getTrackedDifference() {
        return this.diffTracker == null ? null : this.diffTracker.getDifference();
    }

    void onClick(List<ItemStack> oldItems, List<ItemStack> newItems) {
        if (this.diffTracker != null) {
            this.diffTracker.onClick(oldItems, newItems);
        }
    }

    void onClose() {
        if (this.diffTracker != null) {
            this.diffTracker.onClose();
        }
    }

    @Override
    public InventoryType getType() {
        return InventoryType.CHEST;
    }
}

