/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.glowstone;

import com.janboerman.invsee.glowstone.GlowstoneHacks;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.resolve.NameResolveStrategy;
import com.janboerman.invsee.spigot.internal.CompletedEmpty;
import com.janboerman.invsee.utils.Rethrow;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.glowstone.GlowServer;
import net.glowstone.io.nbt.NbtPlayerDataService;
import net.glowstone.util.nbt.CompoundTag;
import org.bukkit.plugin.Plugin;

public class NameSearchSaveFilesStrategy
implements NameResolveStrategy {
    private final Plugin plugin;
    private final Scheduler scheduler;

    public NameSearchSaveFilesStrategy(Plugin plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
    }

    @Override
    public CompletableFuture<Optional<String>> resolveUserName(UUID uniqueId) {
        GlowServer server = (GlowServer)this.plugin.getServer();
        NbtPlayerDataService playerDataService = (NbtPlayerDataService)server.getPlayerDataService();
        File playerDirectory = GlowstoneHacks.getPlayerDir(playerDataService);
        if (!playerDirectory.exists() || !playerDirectory.isDirectory()) {
            return CompletedEmpty.the();
        }
        File playerFile = new File(playerDirectory, uniqueId.toString() + ".dat");
        if (!playerFile.exists() || playerFile.isDirectory()) {
            return CompletedEmpty.the();
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                CompoundTag bukkit;
                CompoundTag compound = GlowstoneHacks.readCompressed(playerFile);
                if (compound.isCompound("bukkit") && (bukkit = compound.getCompound("bukkit")).isString("lastKnownName")) {
                    return Optional.of(bukkit.getString("lastKnownName"));
                }
                return Optional.empty();
            }
            catch (IOException e) {
                return (Optional)Rethrow.unchecked(e);
            }
        }, this.scheduler::executeAsync);
    }
}

