/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.mojangapi;

import com.janboerman.invsee.jsonsimple.JSONObject;
import com.janboerman.invsee.mojangapi.ResponseUtils;
import com.janboerman.invsee.utils.Rethrow;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ElectroidAPI {
    private final Executor asyncExecutor;

    public ElectroidAPI(Executor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    public CompletableFuture<Optional<UUID>> lookupUniqueId(String userName) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + userName);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setRequestProperty("Accept", "application/json");
                connection.setRequestProperty("User-Agent", "InvSee++/MojangAPI");
                int statusCode = connection.getResponseCode();
                switch (statusCode) {
                    case 200: {
                        JSONObject json = ResponseUtils.readJSONObject(connection);
                        String uuid = (String)json.get("uuid");
                        return Optional.of(UUID.fromString(uuid));
                    }
                    case 204: {
                        return Optional.empty();
                    }
                }
                throw new RuntimeException("Unexpected response from Electroid mojang api, status code=" + statusCode + ".");
            }
            catch (IOException e) {
                return (Optional)Rethrow.unchecked(e);
            }
        }, this.asyncExecutor);
    }

    public CompletableFuture<Optional<String>> lookupUserName(UUID uniqueId) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + uniqueId.toString());
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setRequestProperty("Accept", "application/json");
                connection.setRequestProperty("User-Agent", "InvSee++/MojangAPI");
                int statusCode = connection.getResponseCode();
                switch (statusCode) {
                    case 200: {
                        JSONObject json = ResponseUtils.readJSONObject(connection);
                        String userName = (String)json.get("username");
                        return Optional.of(userName);
                    }
                    case 204: {
                        return Optional.empty();
                    }
                }
                throw new RuntimeException("Unexpected response from Electroid mojang api, status code=" + statusCode + ".");
            }
            catch (IOException e) {
                return (Optional)Rethrow.unchecked(e);
            }
        }, this.asyncExecutor);
    }
}

