/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.paper;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.janboerman.invsee.spigot.InvseePlusPlus;
import com.janboerman.invsee.spigot.api.InvseeAPI;
import com.janboerman.invsee.spigot.api.OfflinePlayerProvider;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.perworldinventory.PerWorldInventorySeeApi;
import com.janboerman.invsee.spigot.perworldinventory.PwiCommandArgs;
import com.janboerman.invsee.utils.Compat;
import com.janboerman.invsee.utils.StringHelper;
import com.janboerman.invsee.utils.UsernameTrie;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class AsyncTabCompleter
implements Listener {
    private final Set<UUID> playersWhoCanTabComplete = new ConcurrentSkipListSet<UUID>();
    private final Set<String> knownLabels;
    private final InvseeAPI api;
    private final UsernameTrie<Void> knownPlayerNames = new UsernameTrie();
    private final ConcurrentLinkedQueue<String> nameQueue = new ConcurrentLinkedQueue();

    public AsyncTabCompleter(InvseePlusPlus plugin, Scheduler scheduler, OfflinePlayerProvider playerDatabase) {
        this.api = plugin.getApi();
        this.knownLabels = new ConcurrentSkipListSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.knownLabels.addAll(Compat.listOf("invsee", "inventorysee", "isee", "endersee", "enderchestsee", "esee"));
        String pluginNameLower = "invseeplusplus";
        List withPrefix = this.knownLabels.stream().map(s -> pluginNameLower + ":" + s).collect(Collectors.toList());
        this.knownLabels.addAll(withPrefix);
        scheduler.executeAsync(() -> playerDatabase.getAll(this::enqueue));
        scheduler.executeSyncGlobalRepeatedly(() -> {
            Set tabcompleters = plugin.getServer().getPluginManager().getPermissionSubscriptions("invseeplusplus.tabcomplete").stream().filter(permissible -> permissible.hasPermission("invseeplusplus.tabcomplete")).filter(permissible -> permissible instanceof Player).map(permissible -> ((Player)permissible).getUniqueId()).collect(Collectors.toSet());
            this.playersWhoCanTabComplete.addAll(tabcompleters);
            this.playersWhoCanTabComplete.retainAll(tabcompleters);
        }, 0L, 1200L);
    }

    private void enqueue(String name) {
        if (name != null) {
            this.nameQueue.add(name);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.enqueue(event.getPlayer().getName());
        if (event.getPlayer().hasPermission("invseeplusplus.tabcomplete")) {
            this.playersWhoCanTabComplete.add(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler
    public void onTabComplete(AsyncTabCompleteEvent event) {
        String buffer = event.getBuffer();
        while (!this.nameQueue.isEmpty()) {
            String name2 = this.nameQueue.poll();
            if (name2 == null) continue;
            this.knownPlayerNames.insert(name2, null);
        }
        if (event.isCommand()) {
            String matchedLabel = null;
            boolean equalsIgnoreCase = false;
            boolean prefixIgnoreCase = false;
            for (String label : this.knownLabels) {
                if (buffer.equalsIgnoreCase("/" + label + " ")) {
                    matchedLabel = label;
                    equalsIgnoreCase = true;
                    break;
                }
                if (!StringHelper.startsWithIgnoreCase(buffer, "/" + label + " ")) continue;
                matchedLabel = label;
                prefixIgnoreCase = true;
                break;
            }
            if ((equalsIgnoreCase || prefixIgnoreCase) && event.getSender() instanceof Player && !this.playersWhoCanTabComplete.contains(((Player)event.getSender()).getUniqueId())) {
                event.setHandled(true);
                return;
            }
            if (equalsIgnoreCase) {
                ArrayList playerNames = new ArrayList();
                this.knownPlayerNames.traverse("", (name, v) -> playerNames.add(name));
                if (!playerNames.isEmpty()) {
                    event.setCompletions(playerNames);
                    event.setHandled(true);
                }
            } else if (prefixIgnoreCase) {
                String[] split = buffer.split("\\s");
                if (split.length == 2) {
                    ArrayList playerNames = new ArrayList();
                    String prefix = buffer.substring(matchedLabel.length() + 2);
                    this.knownPlayerNames.traverse(prefix, (name, v) -> playerNames.add(name));
                    if (!playerNames.isEmpty()) {
                        event.setCompletions(playerNames);
                        event.setHandled(true);
                    }
                } else if (split.length == 3 && this.api instanceof PerWorldInventorySeeApi) {
                    PerWorldInventorySeeApi pwiApi = (PerWorldInventorySeeApi)this.api;
                    String pwiArgument = split[2];
                    List<String> pwiCompletions = PwiCommandArgs.complete(pwiArgument, pwiApi.getHook());
                    event.setCompletions(pwiCompletions);
                    event.setHandled(true);
                }
            }
        }
    }
}

