/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot;

import com.janboerman.invsee.spigot.InvseePlusPlus;
import com.janboerman.invsee.spigot.api.InvseeAPI;
import com.janboerman.invsee.spigot.perworldinventory.PerWorldInventorySeeApi;
import com.janboerman.invsee.spigot.perworldinventory.PwiCommandArgs;
import com.janboerman.invsee.utils.Compat;
import com.janboerman.invsee.utils.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class InvseeTabCompleter
implements TabCompleter {
    private final InvseePlusPlus plugin;

    public InvseeTabCompleter(InvseePlusPlus plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        if (!sender.hasPermission("invseeplusplus.tabcomplete")) {
            return Compat.emptyList();
        }
        InvseeAPI api = this.plugin.getApi();
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (args.length == 0) {
            Collection onlinePlayers = sender.getServer().getOnlinePlayers();
            ArrayList<String> onlineNames = new ArrayList<String>(onlinePlayers.size());
            if (player == null) {
                for (Player onlinePlayer : onlinePlayers) {
                    onlineNames.add(onlinePlayer.getName());
                }
            } else {
                for (Player onlinePlayer : onlinePlayers) {
                    if (!player.canSee(onlinePlayer)) continue;
                    onlineNames.add(onlinePlayer.getName());
                }
            }
            if (this.plugin.offlinePlayerSupport() && this.plugin.offlinePlayerSupport()) {
                Set<String> offlineNames = api.getUuidCache().keySet();
                TreeSet<String> allNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                allNames.addAll(onlineNames);
                allNames.addAll(offlineNames);
                return Compat.listCopy(allNames);
            }
            onlineNames.sort(String.CASE_INSENSITIVE_ORDER);
            return onlineNames;
        }
        if (args.length == 1) {
            String onlineName;
            String prefix = args[0];
            Collection onlinePlayers = sender.getServer().getOnlinePlayers();
            ArrayList<String> onlineNames = new ArrayList<String>();
            if (player == null) {
                for (Player onlinePlayer : onlinePlayers) {
                    onlineName = onlinePlayer.getName();
                    if (!StringHelper.startsWithIgnoreCase(onlineName, prefix)) continue;
                    onlineNames.add(onlineName);
                }
            } else {
                for (Player onlinePlayer : onlinePlayers) {
                    onlineName = onlinePlayer.getName();
                    if (!player.canSee(onlinePlayer) || !StringHelper.startsWithIgnoreCase(onlineName, prefix)) continue;
                    onlineNames.add(onlineName);
                }
            }
            if (this.plugin.offlinePlayerSupport() && this.plugin.tabCompleteOfflinePlayers()) {
                TreeSet allNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                allNames.addAll(onlineNames);
                for (String offlineName : api.getUuidCache().keySet()) {
                    if (!StringHelper.startsWithIgnoreCase(offlineName, prefix)) continue;
                    allNames.add(offlineName);
                }
                return Compat.listCopy(allNames);
            }
            onlineNames.sort(String.CASE_INSENSITIVE_ORDER);
            return onlineNames;
        }
        if (args.length == 2 && api instanceof PerWorldInventorySeeApi) {
            PerWorldInventorySeeApi pwiApi = (PerWorldInventorySeeApi)api;
            String pwiArgument = args[1];
            return PwiCommandArgs.complete(pwiArgument, pwiApi.getHook());
        }
        return Compat.emptyList();
    }
}

