/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api;

import com.janboerman.invsee.spigot.api.Title;
import com.janboerman.invsee.spigot.api.logging.LogGranularity;
import com.janboerman.invsee.spigot.api.logging.LogOptions;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderPalette;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CreationOptions<Slot>
implements Cloneable {
    private Plugin plugin;
    private Title title;
    private boolean offlinePlayerSupport = true;
    private Mirror<Slot> mirror;
    private boolean unknownPlayerSupport = true;
    private boolean bypassExempt = false;
    private LogOptions logOptions = new LogOptions();
    private PlaceholderPalette placeholderPalette = PlaceholderPalette.empty();

    CreationOptions(Plugin plugin, Title title, boolean offlinePlayerSupport, Mirror<Slot> mirror, boolean unknownPlayerSupport, boolean bypassExempt, LogOptions logOptions, PlaceholderPalette palette) {
        this.plugin = plugin;
        this.title = Objects.requireNonNull(title);
        this.offlinePlayerSupport = offlinePlayerSupport;
        this.mirror = Objects.requireNonNull(mirror);
        this.unknownPlayerSupport = unknownPlayerSupport;
        this.bypassExempt = bypassExempt;
        this.logOptions = Objects.requireNonNull(logOptions);
        this.placeholderPalette = palette;
    }

    public static <Slot> CreationOptions<Slot> of(Plugin plugin, Title title, boolean offlinePlayerSupport, Mirror<Slot> mirror, boolean unknownPlayerSupport, boolean bypassExempt, LogOptions logOptions, PlaceholderPalette placeholderPalette) {
        return new CreationOptions<Slot>(plugin, title, offlinePlayerSupport, mirror, unknownPlayerSupport, bypassExempt, logOptions, placeholderPalette);
    }

    @Deprecated
    public static <Slot> CreationOptions<Slot> of(Title title, boolean offlinePlayerSupport, Mirror<Slot> mirror, boolean unknownPlayerSupport) throws Exception {
        JavaPlugin plugin = JavaPlugin.getPlugin(Class.forName("com.janboerman.invsee.spigot.InvseePlusPlus"));
        return new CreationOptions<Slot>((Plugin)plugin, title, offlinePlayerSupport, mirror, unknownPlayerSupport, false, new LogOptions().withGranularity(LogGranularity.LOG_NEVER), PlaceholderPalette.empty());
    }

    @Deprecated
    public static <Slot> CreationOptions<Slot> of(Title title, boolean offlinePlayerSupport, Mirror<Slot> mirror, boolean unknownPlayerSupport, boolean bypassExempt) throws Exception {
        JavaPlugin plugin = JavaPlugin.getPlugin(Class.forName("com.janboerman.invsee.spigot.InvseePlusPlus"));
        return new CreationOptions<Slot>((Plugin)plugin, title, offlinePlayerSupport, mirror, unknownPlayerSupport, bypassExempt, new LogOptions().withGranularity(LogGranularity.LOG_NEVER), PlaceholderPalette.empty());
    }

    @Deprecated
    public static <Slot> CreationOptions<Slot> of(Plugin plugin, Title title, boolean offlinePlayerSupport, Mirror<Slot> mirror, boolean unknownPlayerSupport, boolean bypassExempt, LogOptions logOptions) {
        return new CreationOptions<Slot>(plugin, title, offlinePlayerSupport, mirror, unknownPlayerSupport, bypassExempt, logOptions, PlaceholderPalette.empty());
    }

    @Deprecated
    public static CreationOptions<PlayerInventorySlot> defaultMainInventory() {
        return CreationOptions.defaultMainInventory(Bukkit.getPluginManager().getPlugin("InvseePlusPlus"));
    }

    public static CreationOptions<PlayerInventorySlot> defaultMainInventory(Plugin plugin) {
        return new CreationOptions<PlayerInventorySlot>(plugin, Title.defaultMainInventory(), true, Mirror.defaultPlayerInventory(), true, false, new LogOptions(), PlaceholderPalette.empty());
    }

    @Deprecated
    public static CreationOptions<EnderChestSlot> defaultEnderInventory() {
        return CreationOptions.defaultEnderInventory(Bukkit.getPluginManager().getPlugin("InvseePlusPlus"));
    }

    public static CreationOptions<EnderChestSlot> defaultEnderInventory(Plugin plugin) {
        return new CreationOptions<EnderChestSlot>(plugin, Title.defaultEnderInventory(), true, Mirror.defaultEnderChest(), true, false, new LogOptions(), PlaceholderPalette.empty());
    }

    public CreationOptions<Slot> clone() {
        return new CreationOptions<Slot>(this.getPlugin(), this.getTitle(), this.isOfflinePlayerSupported(), this.getMirror(), this.isUnknownPlayerSupported(), this.canBypassExemptedPlayers(), this.getLogOptions().clone(), this.getPlaceholderPalette());
    }

    public CreationOptions<Slot> withPlugin(Plugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin cannot be null");
        return this;
    }

    public CreationOptions<Slot> withTitle(Title title) {
        this.title = Objects.requireNonNull(title, "title cannot be null");
        return this;
    }

    public CreationOptions<Slot> withTitle(String title) {
        return this.withTitle(Title.of(title));
    }

    public CreationOptions<Slot> withOfflinePlayerSupport(boolean offlinePlayerSupport) {
        this.offlinePlayerSupport = offlinePlayerSupport;
        return this;
    }

    public CreationOptions<Slot> withMirror(Mirror<Slot> mirror) {
        this.mirror = Objects.requireNonNull(mirror, "mirror cannot be null");
        return this;
    }

    public CreationOptions<Slot> withUnknownPlayerSupport(boolean unknownPlayerSupport) {
        this.unknownPlayerSupport = unknownPlayerSupport;
        return this;
    }

    public CreationOptions<Slot> withBypassExemptedPlayers(boolean bypassExemptedPlayers) {
        this.bypassExempt = bypassExemptedPlayers;
        return this;
    }

    public CreationOptions<Slot> withLogOptions(LogOptions logOptions) {
        this.logOptions = Objects.requireNonNull(logOptions, "logOptions cannot be null");
        return this;
    }

    public CreationOptions<Slot> withPlaceholderPalette(PlaceholderPalette placeholderPalette) {
        this.placeholderPalette = placeholderPalette;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreationOptions)) {
            return false;
        }
        CreationOptions that = (CreationOptions)o;
        return this.getPlugin().equals((Object)that.getPlugin()) && this.getTitle().equals(that.getTitle()) && this.isOfflinePlayerSupported() == that.isOfflinePlayerSupported() && this.getMirror() == that.getMirror() && this.isUnknownPlayerSupported() == that.isUnknownPlayerSupported() && this.canBypassExemptedPlayers() == that.canBypassExemptedPlayers() && Objects.equals(this.getLogOptions(), that.getLogOptions()) && Objects.equals(this.getPlaceholderPalette(), that.getPlaceholderPalette());
    }

    public int hashCode() {
        return Objects.hash(this.getPlugin(), this.getTitle(), this.isOfflinePlayerSupported(), this.getMirror(), this.isUnknownPlayerSupported(), this.getLogOptions(), this.getPlaceholderPalette());
    }

    public String toString() {
        return "CreationOptions{plugin=" + this.getPlugin() + ",title=" + this.getTitle() + ",offlinePlayerSupport=" + this.isOfflinePlayerSupported() + ",mirror=" + this.getMirror() + ",unknownPlayerSupport=" + this.isUnknownPlayerSupported() + ",bypassExempt=" + this.canBypassExemptedPlayers() + ",logOptions=" + this.getLogOptions() + ",placeholderPalette=" + this.getPlaceholderPalette() + "}";
    }

    public Plugin getPlugin() {
        if (this.plugin == null) {
            try {
                this.plugin = JavaPlugin.getPlugin(Class.forName("com.janboerman.invsee.spigot.InvseePlusPlus"));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Woops, I screwed up severely. Please report this issue (including stack trace) at https://github.com/Jannyboy11/InvSee-plus-plus", e);
            }
        }
        return this.plugin;
    }

    public Title getTitle() {
        return this.title;
    }

    public boolean isOfflinePlayerSupported() {
        return this.offlinePlayerSupport;
    }

    public Mirror<Slot> getMirror() {
        return this.mirror;
    }

    public boolean isUnknownPlayerSupported() {
        return this.unknownPlayerSupport;
    }

    public boolean canBypassExemptedPlayers() {
        return this.bypassExempt;
    }

    public LogOptions getLogOptions() {
        return this.logOptions;
    }

    public PlaceholderPalette getPlaceholderPalette() {
        return this.placeholderPalette;
    }
}

