/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api;

import com.janboerman.invsee.spigot.api.target.PlayerTarget;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.target.UniqueIdTarget;
import com.janboerman.invsee.spigot.api.target.UsernameTarget;
import java.util.Objects;
import java.util.UUID;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicesManager;

public class Exempt {
    private static final String EXEMPT_INVENTORY = "invseeplusplus.exempt.invsee";
    private static final String EXEMPT_ENDERCHEST = "invseeplusplus.exempt.endersee";
    public static final String BYPASS_EXEMPT_INVENTORY = "invseeplusplus.bypass-exempt.invsee";
    public static final String BYPASS_EXEMPT_ENDERCHEST = "invseeplusplus.bypass-exempt.endersee";
    private Server server;
    private Permission permission;

    Exempt(Server server) {
        ServicesManager servicesManager;
        RegisteredServiceProvider provider;
        this.server = Objects.requireNonNull(server);
        if (server.getPluginManager().isPluginEnabled("Vault") && (provider = (servicesManager = server.getServicesManager()).getRegistration(Permission.class)) != null) {
            this.permission = (Permission)provider.getProvider();
        }
    }

    private boolean vaultPermissionEnabled() {
        return this.permission != null && this.permission.isEnabled();
    }

    public boolean isExemptedFromHavingMainInventorySpectated(Target target) {
        return this.isExempted(target, EXEMPT_INVENTORY);
    }

    public boolean isExemptedFromHavingEnderchestSpectated(Target target) {
        return this.isExempted(target, EXEMPT_ENDERCHEST);
    }

    private boolean isExempted(Target target, String permission) {
        if (target instanceof PlayerTarget) {
            return ((PlayerTarget)target).getPlayer().hasPermission(permission);
        }
        if (this.vaultPermissionEnabled()) {
            if (target instanceof UniqueIdTarget) {
                return this.vaultHasPermission(((UniqueIdTarget)target).getUniqueId(), permission);
            }
            if (target instanceof UsernameTarget) {
                return this.vaultHasPermission(((UsernameTarget)target).getUsername(), permission);
            }
        }
        return false;
    }

    private boolean vaultHasPermission(UUID uniqueId, String permission) {
        return this.permission.playerHas(((World)this.server.getWorlds().get(0)).getName(), this.server.getOfflinePlayer(uniqueId), permission);
    }

    @Deprecated
    private boolean vaultHasPermission(String username, String permission) {
        return this.permission.playerHas(((World)this.server.getWorlds().get(0)).getName(), username, permission);
    }

    private boolean vaultHasPermission(UUID uniqueId, String world, String permission) {
        return this.permission.playerHas(world, this.server.getOfflinePlayer(uniqueId), permission);
    }

    @Deprecated
    private boolean vaultHasPermission(String username, String world, String permission) {
        return this.permission.playerHas(world, username, permission);
    }

    public boolean isExemptedFromHavingMainInventorySpectated(Target target, String world) {
        return this.isExempted(target, world, EXEMPT_INVENTORY);
    }

    public boolean isExemptedFromHavingEnderchestSpectated(Target target, String world) {
        return this.isExempted(target, world, EXEMPT_ENDERCHEST);
    }

    private boolean isExempted(Target target, String world, String permission) {
        if (target instanceof PlayerTarget) {
            return ((PlayerTarget)target).getPlayer().hasPermission(permission);
        }
        if (this.vaultPermissionEnabled()) {
            if (target instanceof UniqueIdTarget) {
                return this.vaultHasPermission(((UniqueIdTarget)target).getUniqueId(), world, permission);
            }
            if (target instanceof UsernameTarget) {
                return this.vaultHasPermission(((UsernameTarget)target).getUsername(), world, permission);
            }
        }
        return false;
    }
}

