/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.logging;

import com.janboerman.invsee.spigot.api.logging.Difference;
import com.janboerman.invsee.spigot.api.logging.LogGranularity;
import com.janboerman.invsee.spigot.api.logging.LogOutput;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class DifferenceTracker {
    private final LogOutput output;
    private final LogGranularity granularity;
    private Difference difference;

    public DifferenceTracker(LogOutput output, LogGranularity granularity) {
        assert (granularity != LogGranularity.LOG_NEVER) : "Should not be instantiated with " + LogGranularity.class.getSimpleName() + "." + LogGranularity.LOG_NEVER.name();
        this.output = output;
        this.granularity = granularity;
    }

    public void onOpen() {
        this.difference = new Difference();
    }

    public void onClick(List<ItemStack> oldItems, List<ItemStack> newItems) {
        Difference diff = Difference.calculate(oldItems, newItems);
        if (this.granularity == LogGranularity.LOG_EVERY_CHANGE && !diff.isEmpty()) {
            this.output.log(diff);
        }
        this.difference.merge(diff);
    }

    public void onClose() {
        if (this.granularity == LogGranularity.LOG_ON_CLOSE && !this.difference.isEmpty()) {
            this.output.log(this.difference);
        }
        this.output.close();
    }

    public Difference getDifference() {
        return this.difference;
    }
}

