/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.logging;

import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemType {
    private final Material material;
    private final ItemMeta meta;

    public ItemType(Material material, ItemMeta meta) {
        this.material = material;
        this.meta = meta;
    }

    public static ItemType of(ItemStack stack) {
        if (ItemType.isEmptyStack(stack)) {
            return null;
        }
        return new ItemType(stack.getType(), stack.hasItemMeta() ? stack.getItemMeta() : null);
    }

    public Material getMaterial() {
        return this.material;
    }

    public ItemMeta getItemMeta() {
        return this.meta;
    }

    public String toString() {
        return "ItemType(material=" + this.getMaterial() + ",meta=" + this.getItemMeta() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemType)) {
            return false;
        }
        ItemType that = (ItemType)o;
        return this.getMaterial() == that.getMaterial() && Objects.equals(this.getItemMeta(), that.getItemMeta());
    }

    public int hashCode() {
        return Objects.hash(this.getMaterial(), this.getItemMeta());
    }

    private static boolean isEmptyStack(ItemStack stack) {
        return stack == null || stack.getType() == Material.AIR || stack.getAmount() == 0;
    }
}

