/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.logging;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.logging.FileHandler;

class LogFileHandlers {
    private static FileHandler global;
    private static WeakHashMap<UUID, FileHandler> spectators;
    private static final Object globalLock;
    private static final Object spectatorLock;

    private LogFileHandlers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileHandler getGlobalHandler(File logFileFolder) throws IOException {
        Object object = globalLock;
        synchronized (object) {
            if (global == null) {
                File logFile = new File(logFileFolder, "_global.log");
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                global = new FileHandler(logFile.getAbsolutePath(), true);
            }
            return global;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeGlobalHandler() {
        Object object = globalLock;
        synchronized (object) {
            if (global != null) {
                global.close();
                global = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileHandler getSpectatorHandler(File logFileFolder, UUID spectator) throws IOException {
        Object object = spectatorLock;
        synchronized (object) {
            FileHandler handler = spectators.get(spectator);
            if (handler == null) {
                File logFile = new File(logFileFolder, spectator + ".log");
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                handler = new FileHandler(logFile.getAbsolutePath(), true);
                spectators.put(spectator, handler);
            }
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeSpectatorHandler(UUID spectator) {
        Object object = spectatorLock;
        synchronized (object) {
            FileHandler handler = spectators.remove(spectator);
            if (handler != null) {
                handler.close();
            }
        }
    }

    static {
        spectators = new WeakHashMap();
        globalLock = new Object();
        spectatorLock = new Object();
    }
}

