/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.resolve;

import com.janboerman.invsee.mojangapi.MojangAPI;
import com.janboerman.invsee.spigot.api.resolve.NameResolveStrategy;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class NameMojangAPIStrategy
implements NameResolveStrategy {
    private final Plugin plugin;
    private final MojangAPI mojangApi;

    public NameMojangAPIStrategy(Plugin plugin, MojangAPI mojangApi) {
        this.plugin = Objects.requireNonNull(plugin);
        this.mojangApi = Objects.requireNonNull(mojangApi);
    }

    @Override
    public CompletableFuture<Optional<String>> resolveUserName(UUID uniqueId) {
        return this.mojangApi.lookupUserName(uniqueId).handle((success, error) -> {
            if (error == null) {
                return success;
            }
            this.plugin.getLogger().log(Level.WARNING, "Could not request profile for id " + uniqueId + " from Mojang's REST API", (Throwable)error);
            return Optional.empty();
        });
    }
}

