/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.template;

import com.janboerman.invsee.spigot.api.template.DefaultMirrors;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.internal.template.EnderChestMirror;
import com.janboerman.invsee.spigot.internal.template.PlayerInventoryMirror;

public interface Mirror<Slot> {
    public Integer getIndex(Slot var1);

    public Slot getSlot(int var1);

    public static Mirror<PlayerInventorySlot> defaultPlayerInventory() {
        return DefaultMirrors.DEFAULT_PLAYERINVENTORY_MIRROR;
    }

    public static Mirror<EnderChestSlot> defaultEnderChest() {
        return DefaultMirrors.DEFAULT_ENDERCHEST_MIRROR;
    }

    public static Mirror<PlayerInventorySlot> forInventory(String template) {
        return PlayerInventoryMirror.ofTemplate(template);
    }

    public static Mirror<EnderChestSlot> forEnderChest(String template) {
        return EnderChestMirror.ofTemplate(template);
    }

    public static String toInventoryTemplate(Mirror<PlayerInventorySlot> mirror) {
        if (mirror == DefaultMirrors.DEFAULT_PLAYERINVENTORY_MIRROR) {
            return "i_00 i_01 i_02 i_03 i_04 i_05 i_06 i_07 i_08\ni_09 i_10 i_11 i_12 i_13 i_14 i_15 i_16 i_17\ni_18 i_19 i_20 i_21 i_22 i_23 i_24 i_25 i_26\ni_27 i_28 i_29 i_30 i_31 i_32 i_33 i_34 i_35\na_b  a_l  a_c  a_h  oh   b    s    c    _   \np_00 p_01 p_02 p_03 p_04 p_05 p_06 p_07 p_08";
        }
        return PlayerInventoryMirror.toTemplate(mirror);
    }

    public static String toEnderChestTemplate(Mirror<EnderChestSlot> mirror) {
        if (mirror == DefaultMirrors.DEFAULT_ENDERCHEST_MIRROR) {
            return "e_00 e_01 e_02 e_03 e_04 e_05 e_06 e_07 e_08\ne_09 e_10 e_11 e_12 e_13 e_14 e_15 e_16 e_17\ne_18 e_19 e_20 e_21 e_22 e_23 e_24 e_25 e_26\ne_27 e_28 e_29 e_30 e_31 e_32 e_33 e_34 e_35\ne_36 e_37 e_38 e_39 e_40 e_41 e_42 e_43 e_44\ne_45 e_46 e_47 e_48 e_49 e_50 e_51 e_52 e_53";
        }
        return EnderChestMirror.toTemplate(mirror);
    }
}

