/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_12_R1;

import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.resolve.UUIDResolveStrategy;
import com.janboerman.invsee.spigot.impl_1_12_R1.HybridServerSupport;
import com.janboerman.invsee.spigot.internal.CompletedEmpty;
import com.janboerman.invsee.spigot.internal.LogRecord;
import com.janboerman.invsee.spigot.internal.PlayerFileHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import net.minecraft.server.v1_12_R1.NBTCompressedStreamTools;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.WorldNBTStorage;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.plugin.Plugin;

public class UUIDSearchSaveFilesStrategy
implements UUIDResolveStrategy {
    private final Plugin plugin;
    private final Scheduler scheduler;

    public UUIDSearchSaveFilesStrategy(Plugin plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
    }

    @Override
    public CompletableFuture<Optional<UUID>> resolveUniqueId(String userName) {
        CraftServer craftServer = (CraftServer)this.plugin.getServer();
        WorldNBTStorage worldNBTStorage = (WorldNBTStorage)craftServer.getHandle().playerFileData;
        File playerDirectory = HybridServerSupport.getPlayerDir(worldNBTStorage);
        if (!playerDirectory.exists() || !playerDirectory.isDirectory()) {
            return CompletedEmpty.the();
        }
        return CompletableFuture.supplyAsync(() -> {
            File[] playerFiles = playerDirectory.listFiles((directory, fileName) -> PlayerFileHelper.isPlayerSaveFile(fileName));
            if (playerFiles != null) {
                CopyOnWriteArrayList<LogRecord> errors = new CopyOnWriteArrayList<LogRecord>();
                for (File playerFile : playerFiles) {
                    String fileName2 = playerFile.getName();
                    UUID playerId = UUIDSearchSaveFilesStrategy.uuidFromFileName(fileName2);
                    Executor syncExecutor = playerId == null ? this.scheduler::executeSyncGlobal : runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null);
                    try {
                        CompletionStage<Object> compoundFuture = CompletableFuture.completedFuture(NBTCompressedStreamTools.a((InputStream)new FileInputStream(playerFile)));
                        compoundFuture = ((CompletableFuture)compoundFuture).handleAsync((tag, asyncEx) -> {
                            if (asyncEx == null) {
                                return tag;
                            }
                            try {
                                return NBTCompressedStreamTools.a((InputStream)new FileInputStream(playerFile));
                            }
                            catch (IOException syncEx) {
                                syncEx.addSuppressed((Throwable)asyncEx);
                                throw new CompletionException(syncEx);
                            }
                        }, syncExecutor);
                        try {
                            NBTTagCompound compound = (NBTTagCompound)((CompletableFuture)compoundFuture).get();
                            if (!UUIDSearchSaveFilesStrategy.tagHasLastKnownName(compound, userName)) continue;
                            String uuid = fileName2.substring(0, fileName2.length() - 4);
                            if (uuid.startsWith("-")) {
                                uuid = uuid.substring(1);
                            }
                            try {
                                UUID uniqueId = UUID.fromString(uuid);
                                return Optional.of(uniqueId);
                            }
                            catch (IllegalArgumentException e) {
                                errors.add(new LogRecord(Level.WARNING, "Encountered player save file name that is not a uuid: " + fileName2, e));
                            }
                        }
                        catch (ExecutionException e) {
                            Throwable syncEx = e.getCause();
                            errors.add(new LogRecord(Level.SEVERE, "Encountered player save file containing invalid NBT: " + fileName2, syncEx));
                        }
                        catch (InterruptedException e) {}
                    }
                    catch (IOException e) {
                        this.plugin.getLogger().log(Level.WARNING, "Error reading player's save file: " + playerFile.getAbsolutePath(), e);
                    }
                }
                for (LogRecord error : errors) {
                    this.plugin.getLogger().log(error.level, error.message, error.cause);
                }
            }
            return Optional.empty();
        }, this.scheduler::executeAsync);
    }

    private static boolean tagHasLastKnownName(NBTTagCompound compound, String userName) {
        NBTTagCompound bukkit;
        if (compound.hasKeyOfType("bukkit", 10) && (bukkit = compound.getCompound("bukkit")).hasKeyOfType("lastKnownName", 8)) {
            String lastKnownName = bukkit.getString("lastKnownName");
            return lastKnownName.equalsIgnoreCase(userName);
        }
        return false;
    }

    private static UUID uuidFromFileName(String fileName) {
        if (fileName == null || fileName.length() < 36) {
            return null;
        }
        String uuidChars = fileName.substring(0, 36);
        try {
            return UUID.fromString(uuidChars);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

