/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_16_R3;

import com.janboerman.invsee.spigot.api.EnderSpectatorInventory;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.logging.Difference;
import com.janboerman.invsee.spigot.api.logging.DifferenceTracker;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.impl_1_16_R3.BukkitInventoryView;
import com.janboerman.invsee.spigot.impl_1_16_R3.EnderNmsContainer;
import javax.annotation.Nullable;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

class EnderBukkitInventoryView
extends BukkitInventoryView<EnderChestSlot>
implements EnderSpectatorInventoryView {
    final EnderNmsContainer nms;

    EnderBukkitInventoryView(EnderNmsContainer nms) {
        super(nms.creationOptions);
        this.nms = nms;
    }

    @Override
    public EnderSpectatorInventory getTopInventory() {
        return this.nms.top.bukkit();
    }

    public PlayerInventory getBottomInventory() {
        return this.nms.player.getBukkitEntity().getInventory();
    }

    public HumanEntity getPlayer() {
        return this.nms.player.getBukkitEntity();
    }

    @Override
    public String getTitle() {
        return this.nms.title;
    }

    public void setItem(int slot, ItemStack item) {
        net.minecraft.server.v1_16_R3.ItemStack stack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (slot >= 0) {
            this.nms.getSlot(slot).set(stack);
        } else {
            this.nms.player.drop(stack, false);
        }
    }

    public ItemStack getItem(int slot) {
        if (slot < 0) {
            return null;
        }
        net.minecraft.server.v1_16_R3.ItemStack nmsStack = slot < this.nms.top.getSize() ? this.nms.top.getContents().get(slot) : this.nms.getSlot(slot).getItem();
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_16_R3.ItemStack)nmsStack);
    }

    @Override
    @Nullable
    public Difference getTrackedDifference() {
        DifferenceTracker tracker = this.nms.tracker;
        return tracker == null ? null : tracker.getDifference();
    }

    @Override
    public InventoryType getType() {
        return InventoryType.CHEST;
    }
}

