/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_16_R3;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.impl_1_16_R3.EnderBukkitInventory;
import com.janboerman.invsee.spigot.impl_1_16_R3.EnderNmsContainer;
import com.janboerman.invsee.spigot.impl_1_16_R3.InvseeImpl;
import com.janboerman.invsee.spigot.internal.inventory.ShallowCopy;
import com.janboerman.invsee.utils.UUIDHelper;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.constant.EmptyPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.v1_16_R3.ChatMessage;
import net.minecraft.server.v1_16_R3.Container;
import net.minecraft.server.v1_16_R3.ContainerUtil;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.NonNullList;
import net.minecraft.server.v1_16_R3.PlayerInventory;
import net.minecraft.server.v1_16_R3.TileEntityContainer;
import net.minecraft.server.v1_16_R3.TileEntityTypes;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;

class EnderNmsInventory
extends TileEntityContainer
implements ShallowCopy<EnderNmsInventory> {
    private static final TileEntityTypes TileEntityTypeFakeEnderChest = new TileEntityTypes(EnderNmsInventory::new, Set.of(), (Type)new EmptyPart());
    protected final UUID spectatedPlayerUuid;
    protected final String spectatedPlayerName;
    protected NonNullList<ItemStack> storageContents;
    private EnderBukkitInventory bukkit;
    protected CreationOptions<EnderChestSlot> creationOptions;
    private int maxStack = 64;
    private final List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    protected InventoryHolder owner;

    private EnderNmsInventory() {
        super(TileEntityTypeFakeEnderChest);
        this.spectatedPlayerUuid = null;
        this.spectatedPlayerName = null;
        this.storageContents = null;
    }

    EnderNmsInventory(UUID spectatedPlayerUuid, String spectatedPlayerName, NonNullList<ItemStack> storageContents, CreationOptions<EnderChestSlot> creationOptions) {
        super(TileEntityTypeFakeEnderChest);
        this.spectatedPlayerUuid = UUIDHelper.copy(spectatedPlayerUuid);
        this.spectatedPlayerName = spectatedPlayerName;
        this.storageContents = storageContents;
        this.creationOptions = creationOptions;
    }

    public EnderBukkitInventory bukkit() {
        return this.bukkit == null ? (this.bukkit = new EnderBukkitInventory(this)) : this.bukkit;
    }

    @Override
    public int defaultMaxStack() {
        return 64;
    }

    @Override
    public void shallowCopyFrom(EnderNmsInventory from) {
        this.storageContents = from.storageContents;
        this.update();
    }

    public int getSize() {
        return this.storageContents.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.storageContents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        if (slot < 0 || slot >= this.getSize()) {
            return InvseeImpl.EMPTY_STACK;
        }
        return (ItemStack)this.storageContents.get(slot);
    }

    public ItemStack splitStack(int slot, int subtractAmount) {
        if (slot < 0 || slot >= this.getSize()) {
            return InvseeImpl.EMPTY_STACK;
        }
        ItemStack stack = ContainerUtil.a(this.storageContents, (int)slot, (int)subtractAmount);
        if (!stack.isEmpty()) {
            this.update();
        }
        return stack;
    }

    public ItemStack splitWithoutUpdate(int slot) {
        if (slot < 0 || slot >= this.getSize()) {
            return InvseeImpl.EMPTY_STACK;
        }
        ItemStack stack = (ItemStack)this.storageContents.get(slot);
        if (stack.isEmpty()) {
            return InvseeImpl.EMPTY_STACK;
        }
        this.storageContents.set(slot, (Object)InvseeImpl.EMPTY_STACK);
        return stack;
    }

    public void setItem(int slot, ItemStack itemStack) {
        if (slot < 0 || slot >= this.getSize()) {
            return;
        }
        this.storageContents.set(slot, (Object)itemStack);
        if (!itemStack.isEmpty() && itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
        this.update();
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    public void update() {
        for (HumanEntity viewer : this.getViewers()) {
            if (!(viewer instanceof Player)) continue;
            ((Player)viewer).updateInventory();
        }
    }

    public boolean a(EntityHuman entityHuman) {
        return true;
    }

    public List<ItemStack> getContents() {
        return this.storageContents;
    }

    public void onOpen(CraftHumanEntity who) {
        this.transaction.add((HumanEntity)who);
    }

    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    public InventoryHolder getOwner() {
        return this.owner;
    }

    public void setMaxStackSize(int maxStack) {
        this.maxStack = maxStack;
    }

    public Location getLocation() {
        return null;
    }

    public void clear() {
        this.storageContents.clear();
    }

    public IChatBaseComponent getScoreboardDisplayName() {
        return CraftChatMessage.fromStringOrNull((String)this.creationOptions.getTitle().titleFor(Target.byGameProfile(this.spectatedPlayerUuid, this.spectatedPlayerName)));
    }

    protected IChatBaseComponent getContainerName() {
        return new ChatMessage("minecraft:generic_9x" + this.storageContents.size() / 9);
    }

    protected Container createContainer(int containerId, PlayerInventory playerInventory) {
        return new EnderNmsContainer(containerId, this, playerInventory, playerInventory.player, this.creationOptions);
    }

    public boolean e(EntityHuman entityhuman) {
        return true;
    }

    public boolean func_191420_l() {
        return this.isEmpty();
    }

    public ItemStack func_70301_a(int idx) {
        return this.getItem(idx);
    }

    public int func_70302_i_() {
        return this.getSize();
    }

    public ItemStack func_70298_a(int slot, int subtractAmount) {
        return this.splitStack(slot, subtractAmount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.splitWithoutUpdate(slot);
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.setItem(slot, itemStack);
    }

    public int func_70297_j_() {
        return this.getMaxStackSize();
    }

    public void func_70296_d() {
        this.update();
    }

    public boolean func_70300_a(EntityHuman playerEntity) {
        return this.a(playerEntity);
    }
}

