/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_17_1_R1;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.MainBukkitInventory;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.MainNmsContainer;
import com.janboerman.invsee.spigot.internal.inventory.AbstractNmsInventory;
import com.janboerman.invsee.utils.ConcatList;
import com.janboerman.invsee.utils.Ref;
import com.janboerman.invsee.utils.SingletonList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

class MainNmsInventory
extends AbstractNmsInventory<PlayerInventorySlot, MainBukkitInventory, MainNmsInventory>
implements IInventory,
ITileInventory {
    protected final UUID targetPlayerUuid;
    protected final String targetPlayerName;
    protected NonNullList<ItemStack> storageContents;
    protected NonNullList<ItemStack> armourContents;
    protected NonNullList<ItemStack> offHand;
    protected Ref<ItemStack> onCursor;
    protected List<ItemStack> craftingContents;
    protected List<ItemStack> personalContents;
    private int maxStack = 64;
    private final List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    protected InventoryHolder owner;

    MainNmsInventory(final EntityHuman target, CreationOptions<PlayerInventorySlot> creationOptions) {
        super(target.getUniqueID(), target.getName(), creationOptions);
        this.targetPlayerUuid = target.getUniqueID();
        this.targetPlayerName = target.getName();
        PlayerInventory inv = target.getInventory();
        this.storageContents = inv.h;
        this.armourContents = inv.i;
        this.offHand = inv.j;
        this.onCursor = new Ref<ItemStack>(this){
            final /* synthetic */ MainNmsInventory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void set(ItemStack item) {
                target.bV.setCarried(item);
            }

            @Override
            public ItemStack get() {
                return target.bV.getCarried();
            }
        };
        this.personalContents = this.craftingContents = target.bU.q().getContents();
    }

    @Override
    protected MainBukkitInventory createBukkit() {
        return new MainBukkitInventory(this);
    }

    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public int defaultMaxStack() {
        return 64;
    }

    @Override
    public void shallowCopyFrom(MainNmsInventory from) {
        this.setMaxStackSize(from.getMaxStackSize());
        this.storageContents = from.storageContents;
        this.armourContents = from.armourContents;
        this.offHand = from.offHand;
        this.onCursor = from.onCursor;
        this.craftingContents = from.craftingContents;
        this.personalContents = from.personalContents;
        this.update();
    }

    private Ref<ItemStack> decideWhichItem(int slot) {
        int idx;
        int storageSize = this.storageContents.size();
        if (0 <= slot && slot < storageSize) {
            int idx2 = slot;
            return Ref.ofList(idx2, this.storageContents);
        }
        int armourSize = this.armourContents.size();
        if (storageSize <= slot && slot < storageSize + armourSize) {
            int idx3 = slot - storageSize;
            return Ref.ofList(idx3, this.armourContents);
        }
        int offHandSize = this.offHand.size();
        if (storageSize + armourSize <= slot && slot < storageSize + armourSize + offHandSize) {
            int idx4 = slot - storageSize - armourSize;
            return Ref.ofList(idx4, this.offHand);
        }
        if (storageSize + armourSize + offHandSize == slot) {
            return this.onCursor;
        }
        if (45 <= slot && slot < 54 && (idx = slot - 45) < this.personalContents.size()) {
            return Ref.ofList(idx, this.personalContents);
        }
        return null;
    }

    public void clear() {
        this.storageContents.clear();
        this.armourContents.clear();
        this.offHand.clear();
        this.onCursor.set(ItemStack.b);
        this.personalContents.clear();
        if (this.craftingContents != this.personalContents) {
            this.craftingContents.clear();
        }
    }

    public Container createMenu(int containerId, PlayerInventory playerInventory, EntityHuman viewer) {
        return new MainNmsContainer(containerId, this, playerInventory, viewer, this.creationOptions);
    }

    public IChatBaseComponent getScoreboardDisplayName() {
        return CraftChatMessage.fromStringOrNull((String)this.creationOptions.getTitle().titleFor(Target.byGameProfile(this.targetPlayerUuid, this.targetPlayerName)));
    }

    public int getSize() {
        return 54;
    }

    public List<ItemStack> getContents() {
        NonNullList paddingOne = NonNullList.a((int)(45 - this.storageContents.size() - this.armourContents.size() - this.offHand.size() - 1), (Object)ItemStack.b);
        NonNullList paddingTwo = NonNullList.a((int)(9 - this.personalContents.size()), (Object)ItemStack.b);
        return new ConcatList<ItemStack>((List<ItemStack>)this.storageContents, (List<ItemStack>)new ConcatList<ItemStack>((List<ItemStack>)this.armourContents, (List<ItemStack>)new ConcatList<ItemStack>((List<ItemStack>)this.offHand, (List<ItemStack>)new ConcatList<ItemStack>(new SingletonList<ItemStack>(this.onCursor), new ConcatList<ItemStack>((List<ItemStack>)paddingOne, (List<ItemStack>)new ConcatList<ItemStack>(this.personalContents, (List<ItemStack>)paddingTwo))))));
    }

    public ItemStack getItem(int slot) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return ItemStack.b;
        }
        return ref.get();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.armourContents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (ItemStack stack : this.storageContents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (ItemStack stack : this.offHand) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (ItemStack stack : this.personalContents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return this.onCursor.get().isEmpty();
    }

    public void onClose(CraftHumanEntity bukkitPlayer) {
        this.transaction.remove(bukkitPlayer);
    }

    public void onOpen(CraftHumanEntity bukkitPlayer) {
        this.transaction.add((HumanEntity)bukkitPlayer);
    }

    public ItemStack splitStack(int slot, int amount) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return ItemStack.b;
        }
        ItemStack stack = ref.get();
        if (!stack.isEmpty() && amount > 0) {
            ItemStack oldStackCopy = ref.get().cloneAndSubtract(amount);
            if (!oldStackCopy.isEmpty()) {
                this.update();
            }
            return oldStackCopy;
        }
        return ItemStack.b;
    }

    public ItemStack splitWithoutUpdate(int slot) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return ItemStack.b;
        }
        ItemStack stack = ref.get();
        if (stack.isEmpty()) {
            return ItemStack.b;
        }
        ref.set(ItemStack.b);
        return stack;
    }

    public void update() {
    }

    public void setItem(int slot, ItemStack stack) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return;
        }
        ref.set(stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.update();
    }

    public boolean a(EntityHuman arg0) {
        return true;
    }
}

