/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_20_1_R1;

import com.janboerman.invsee.spigot.api.EnderSpectatorInventory;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.logging.Difference;
import com.janboerman.invsee.spigot.api.logging.DifferenceTracker;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.impl_1_20_1_R1.BukkitInventoryView;
import com.janboerman.invsee.spigot.impl_1_20_1_R1.EnderNmsContainer;
import javax.annotation.Nullable;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

class EnderBukkitInventoryView
extends BukkitInventoryView<EnderChestSlot>
implements EnderSpectatorInventoryView {
    final EnderNmsContainer nms;

    EnderBukkitInventoryView(EnderNmsContainer nms) {
        super(nms.creationOptions);
        this.nms = nms;
    }

    @Override
    public EnderSpectatorInventory getTopInventory() {
        return (EnderSpectatorInventory)this.nms.top.bukkit();
    }

    public PlayerInventory getBottomInventory() {
        return this.nms.player.getBukkitEntity().getInventory();
    }

    public HumanEntity getPlayer() {
        return this.nms.player.getBukkitEntity();
    }

    @Override
    public InventoryType getType() {
        return InventoryType.CHEST;
    }

    @Override
    public String getTitle() {
        return this.nms.title();
    }

    public String getOriginalTitle() {
        return this.nms.originalTitle;
    }

    public void setTitle(String title) {
        CraftInventoryView.sendInventoryTitleChange((InventoryView)this, (String)title);
        this.nms.title = title;
    }

    public void setItem(int slot, ItemStack item) {
        net.minecraft.world.item.ItemStack stack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (slot >= 0) {
            this.nms.b(slot).e(stack);
        } else {
            this.nms.player.a(stack, false);
        }
    }

    public ItemStack getItem(int slot) {
        if (slot < 0) {
            return null;
        }
        net.minecraft.world.item.ItemStack nmsStack = slot < this.nms.top.b() ? this.nms.top.getContents().get(slot) : this.nms.b(slot).e();
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nmsStack);
    }

    @Override
    @Nullable
    public Difference getTrackedDifference() {
        DifferenceTracker tracker = this.nms.tracker;
        return tracker == null ? null : tracker.getDifference();
    }
}

