/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_21_4_R3;

import com.janboerman.invsee.utils.FuzzyReflection;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.WorldNBTStorage;

public class HybridServerSupport {
    private HybridServerSupport() {
    }

    public static File getPlayerDir(WorldNBTStorage worldNBTStorage) {
        try {
            return worldNBTStorage.getPlayerDir();
        }
        catch (NoSuchMethodError craftbukkitMethodNotFound) {
            try {
                Method method = worldNBTStorage.getClass().getMethod("getPlayerDataFolder", new Class[0]);
                return (File)method.invoke((Object)worldNBTStorage, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException forgeMethodNotFound) {
                Field[] fields;
                Field[] fieldArray = fields = FuzzyReflection.getFieldOfType(WorldNBTStorage.class, File.class);
                int n = fieldArray.length;
                int n2 = 0;
                if (n2 < n) {
                    Field field = fieldArray[n2];
                    try {
                        return (File)field.get(worldNBTStorage);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Could not access player data folder field from PlayerDataStorage", e);
                    }
                }
                RuntimeException ex = new RuntimeException("No method known of getting the player directory");
                ex.addSuppressed(craftbukkitMethodNotFound);
                ex.addSuppressed(forgeMethodNotFound);
                throw ex;
            }
        }
    }

    public static int nextContainerCounter(EntityPlayer nmsPlayer) {
        try {
            return nmsPlayer.nextContainerCounter();
        }
        catch (NoSuchMethodError craftbukkitMethodNotFound) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                MethodHandle methodHandle = lookup.findVirtual(nmsPlayer.getClass(), "nextContainerCounterInt", MethodType.methodType(Integer.TYPE));
                return methodHandle.invoke(nmsPlayer);
            }
            catch (Throwable magmaMethodNotFound) {
                RuntimeException ex = new RuntimeException("No method known of incrementing the player's container counter");
                ex.addSuppressed(craftbukkitMethodNotFound);
                ex.addSuppressed(magmaMethodNotFound);
                throw ex;
            }
        }
    }

    public static NonNullList<ItemStack> enderChestItems(InventoryEnderChest enderChest) {
        try {
            return enderChest.c;
        }
        catch (IllegalAccessError | NoSuchFieldError vanillaFieldIsActuallyPrivate) {
            try {
                return (NonNullList)enderChest.getContents();
            }
            catch (Throwable forgeMethodNotFound) {
                RuntimeException ex = new RuntimeException("No method known of getting the enderchest items");
                ex.addSuppressed(vanillaFieldIsActuallyPrivate);
                ex.addSuppressed(forgeMethodNotFound);
                throw ex;
            }
        }
    }
}

