/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_21_4_R3;

import com.janboerman.invsee.spigot.api.OfflinePlayerProvider;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.impl_1_21_4_R3.HybridServerSupport;
import com.janboerman.invsee.spigot.internal.PlayerFileHelper;
import com.janboerman.invsee.utils.StringHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.minecraft.ReportedException;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.storage.WorldNBTStorage;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.plugin.Plugin;

public class KnownPlayersProvider
implements OfflinePlayerProvider {
    private final Plugin plugin;
    private final Scheduler scheduler;

    public KnownPlayersProvider(Plugin plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
    }

    @Override
    public void getAll(Consumer<String> result) {
        CraftServer craftServer = (CraftServer)this.plugin.getServer();
        WorldNBTStorage worldNBTStorage = craftServer.getHandle().t;
        File playerDirectory = HybridServerSupport.getPlayerDir(worldNBTStorage);
        if (!playerDirectory.exists() || !playerDirectory.isDirectory()) {
            return;
        }
        File[] playerFiles = playerDirectory.listFiles((directory, fileName) -> PlayerFileHelper.isPlayerSaveFile(fileName));
        assert (playerFiles != null) : "playerFiles is not a directory?";
        for (File playerFile : playerFiles) {
            Path filePath = playerFile.toPath();
            try {
                KnownPlayersProvider.readName(result, filePath);
            }
            catch (IOException | ReportedException e1) {
                UUID playerId = KnownPlayersProvider.uuidFromFileName(playerFile.getName());
                Executor executor = playerId == null ? this.scheduler::executeSyncGlobal : runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null);
                executor.execute(() -> this.lambda$getAll$2(result, filePath, (Exception)e1, playerFile));
            }
        }
    }

    @Override
    public void getWithPrefix(String prefix, Consumer<String> result) {
        CraftServer craftServer = (CraftServer)this.plugin.getServer();
        WorldNBTStorage worldNBTStorage = craftServer.getHandle().t;
        File playerDirectory = HybridServerSupport.getPlayerDir(worldNBTStorage);
        if (!playerDirectory.exists() || !playerDirectory.isDirectory()) {
            return;
        }
        File[] playerFiles = playerDirectory.listFiles((directory, fileName) -> PlayerFileHelper.isPlayerSaveFile(fileName));
        assert (playerFiles != null) : "playerFiles is not a directory?";
        for (File playerFile : playerFiles) {
            Path filePath = playerFile.toPath();
            try {
                KnownPlayersProvider.readName(prefix, result, filePath);
            }
            catch (IOException | ReportedException e1) {
                UUID playerId = KnownPlayersProvider.uuidFromFileName(playerFile.getName());
                Executor executor = playerId == null ? this.scheduler::executeSyncGlobal : runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null);
                executor.execute(() -> this.lambda$getWithPrefix$2(prefix, result, filePath, (Exception)e1, playerFile));
            }
        }
    }

    private static UUID uuidFromFileName(String fileName) {
        if (fileName == null | fileName.length() < 36) {
            return null;
        }
        try {
            return UUID.fromString(fileName.substring(0, 36));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static void readName(Consumer<String> reader, Path playerFile) throws IOException, ReportedException {
        String name = KnownPlayersProvider.readName(playerFile);
        if (name != null) {
            reader.accept(name);
        }
    }

    private static void readName(String prefix, Consumer<String> reader, Path playerFile) throws IOException, ReportedException {
        String name = KnownPlayersProvider.readName(playerFile);
        if (name != null && StringHelper.startsWithIgnoreCase(name, prefix)) {
            reader.accept(name);
        }
    }

    private static String readName(Path playerFile) throws IOException, ReportedException {
        NBTTagCompound bukkit;
        NBTTagCompound compound = NBTCompressedStreamTools.a((Path)playerFile, (NBTReadLimiter)NBTReadLimiter.a());
        if (compound.b("bukkit", 10) && (bukkit = compound.p("bukkit")).b("lastKnownName", 8)) {
            return bukkit.l("lastKnownName");
        }
        return null;
    }

    private /* synthetic */ void lambda$getWithPrefix$2(String prefix, Consumer result, Path filePath, Exception e1, File playerFile) {
        try {
            KnownPlayersProvider.readName(prefix, result, filePath);
        }
        catch (IOException | ReportedException e2) {
            e2.addSuppressed(e1);
            this.plugin.getLogger().log(Level.WARNING, "Error reading player's save file " + playerFile.getAbsolutePath(), e2);
        }
    }

    private /* synthetic */ void lambda$getAll$2(Consumer result, Path filePath, Exception e1, File playerFile) {
        try {
            KnownPlayersProvider.readName(result, filePath);
        }
        catch (IOException | ReportedException e2) {
            e2.addSuppressed(e1);
            this.plugin.getLogger().log(Level.WARNING, "Error reading player's save file " + playerFile.getAbsolutePath(), e2);
        }
    }
}

