/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_21_9_R6;

import com.janboerman.invsee.spigot.impl_1_21_9_R6.FakeCraftPlayer;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.HybridServerSupport;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.EnumGamemode;

class FakeEntityPlayer
extends EntityPlayer {
    private static final Method SET_GAME_MODE_FOR_PLAYER = FakeEntityPlayer.findSetGameModeForPlayer();
    private FakeCraftPlayer bukkitEntity;

    public FakeEntityPlayer(MinecraftServer minecraftserver, WorldServer worldserver, GameProfile gameprofile, ClientInformation clientinformation) {
        super(minecraftserver, worldserver, gameprofile, clientinformation);
    }

    public FakeCraftPlayer getBukkitEntity() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = new FakeCraftPlayer(HybridServerSupport.getServer((EntityPlayer)this).server, this);
            try {
                Field craftbukkitField = Entity.class.getDeclaredField("bukkitEntity");
                craftbukkitField.setAccessible(true);
                craftbukkitField.set((Object)this, (Object)this.bukkitEntity);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                Logger.getLogger("Minecraft").log(Level.SEVERE, "Failed to overwrite CraftBukkit's 'bukkitEntity'.", e);
            }
        }
        return this.bukkitEntity;
    }

    void setGameMode(EnumGamemode gameMode, EnumGamemode previousGameMode) {
        if (SET_GAME_MODE_FOR_PLAYER != null) {
            try {
                SET_GAME_MODE_FOR_PLAYER.invoke((Object)this.h, gameMode, previousGameMode);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Could not set gamemode for player.", e);
            }
        }
    }

    private static Method findSetGameModeForPlayer() {
        Object[] expectedParameterTypes = new Class[]{EnumGamemode.class, EnumGamemode.class};
        for (Method m : PlayerInteractManager.class.getDeclaredMethods()) {
            if (!Arrays.equals(m.getParameterTypes(), expectedParameterTypes)) continue;
            m.setAccessible(true);
            return m;
        }
        Logger.getLogger("Minecraft").warning("Failed to find method ServerPlayerGameMode#setGameModeForPlayer(GameType,GameType).");
        return null;
    }
}

