/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_8_R3;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.impl_1_8_R3.EnderBukkitInventory;
import com.janboerman.invsee.spigot.impl_1_8_R3.EnderNmsContainer;
import com.janboerman.invsee.spigot.impl_1_8_R3.InvseeImpl;
import com.janboerman.invsee.spigot.internal.inventory.AbstractNmsInventory;
import java.util.UUID;
import net.minecraft.server.v1_8_R3.Container;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.IChatBaseComponent;
import net.minecraft.server.v1_8_R3.IInventory;
import net.minecraft.server.v1_8_R3.ITileEntityContainer;
import net.minecraft.server.v1_8_R3.ItemStack;
import net.minecraft.server.v1_8_R3.PlayerInventory;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_8_R3.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;

class EnderNmsInventory
extends AbstractNmsInventory<EnderChestSlot, EnderBukkitInventory, EnderNmsInventory>
implements IInventory,
ITileEntityContainer {
    protected ItemStack[] storageContents;

    EnderNmsInventory(UUID spectatedPlayerUuid, String spectatedPlayerName, ItemStack[] storageContents, CreationOptions<EnderChestSlot> creationOptions) {
        super(spectatedPlayerUuid, spectatedPlayerName, creationOptions);
        this.storageContents = storageContents;
    }

    @Override
    protected EnderBukkitInventory createBukkit() {
        return new EnderBukkitInventory(this);
    }

    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public int defaultMaxStack() {
        return 64;
    }

    @Override
    public void shallowCopyFrom(EnderNmsInventory from) {
        this.setMaxStackSize(from.getMaxStackSize());
        this.storageContents = from.storageContents;
        this.update();
    }

    public int getSize() {
        return this.storageContents.length;
    }

    public ItemStack getItem(int slot) {
        if (slot < 0 || slot >= this.getSize()) {
            return InvseeImpl.EMPTY_STACK;
        }
        return this.storageContents[slot];
    }

    public ItemStack splitStack(int slot, int subtractAmount) {
        ItemStack stack;
        if (slot < 0 || slot >= this.getSize() || (stack = this.storageContents[slot]) == null) {
            return InvseeImpl.EMPTY_STACK;
        }
        if (stack.count <= subtractAmount) {
            this.storageContents[slot] = InvseeImpl.EMPTY_STACK;
        } else {
            stack = stack.cloneAndSubtract(subtractAmount);
            if (this.storageContents[slot].count == 0) {
                this.storageContents[slot] = InvseeImpl.EMPTY_STACK;
            }
        }
        this.update();
        return stack;
    }

    public ItemStack splitWithoutUpdate(int slot) {
        if (slot < 0 || slot >= this.getSize()) {
            return InvseeImpl.EMPTY_STACK;
        }
        ItemStack stack = this.storageContents[slot];
        if (stack.count == 0) {
            return InvseeImpl.EMPTY_STACK;
        }
        this.storageContents[slot] = InvseeImpl.EMPTY_STACK;
        return stack;
    }

    public void setItem(int slot, ItemStack itemStack) {
        if (slot < 0 || slot >= this.getSize()) {
            return;
        }
        this.storageContents[slot] = itemStack;
        if (!InvseeImpl.isEmptyStack(itemStack) && itemStack.count > this.getMaxStackSize()) {
            itemStack.count = this.getMaxStackSize();
        }
        this.update();
    }

    public void update() {
    }

    public boolean a(EntityHuman entityHuman) {
        return true;
    }

    public void startOpen(EntityHuman entityHuman) {
        this.onOpen(entityHuman.getBukkitEntity());
    }

    public void closeContainer(EntityHuman entityHuman) {
        this.onClose(entityHuman.getBukkitEntity());
    }

    public boolean b(int slot, ItemStack itemStack) {
        return true;
    }

    public int getProperty(int idx) {
        return 0;
    }

    public void b(int idx, int prop) {
    }

    public int g() {
        return 0;
    }

    public ItemStack[] getContents() {
        return this.storageContents;
    }

    public void onOpen(CraftHumanEntity who) {
        super.onOpen((HumanEntity)who);
    }

    public void onClose(CraftHumanEntity who) {
        super.onClose((HumanEntity)who);
    }

    public void l() {
        for (int i = 0; i < this.storageContents.length; ++i) {
            this.storageContents[i] = InvseeImpl.EMPTY_STACK;
        }
    }

    public String getName() {
        return this.creationOptions.getTitle().titleFor(Target.byGameProfile(this.targetPlayerUuid, this.targetPlayerName));
    }

    public boolean hasCustomName() {
        return this.creationOptions.getTitle() != null;
    }

    public IChatBaseComponent getScoreboardDisplayName() {
        return CraftChatMessage.fromString((String)this.creationOptions.getTitle().titleFor(Target.byGameProfile(this.targetPlayerUuid, this.targetPlayerName)))[0];
    }

    public Container createContainer(PlayerInventory playerInventory, EntityHuman entityHuman) {
        EntityPlayer entityPlayer = (EntityPlayer)entityHuman;
        return new EnderNmsContainer(entityPlayer.nextContainerCounter(), this, playerInventory, playerInventory.player, this.creationOptions);
    }

    public String getContainerName() {
        return "minecraft:container";
    }
}

