/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_8_R3;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.InventoryEnderChest;
import net.minecraft.server.v1_8_R3.ItemStack;
import net.minecraft.server.v1_8_R3.Slot;
import net.minecraft.server.v1_8_R3.WorldNBTStorage;

public class HybridServerSupport {
    private HybridServerSupport() {
    }

    public static File getPlayerDir(WorldNBTStorage worldNBTStorage) {
        try {
            return worldNBTStorage.getPlayerDir();
        }
        catch (NoSuchMethodError craftbukkitMethodNotFound) {
            RuntimeException ex = new RuntimeException("No method known of getting the player directory");
            ex.addSuppressed(craftbukkitMethodNotFound);
            throw ex;
        }
    }

    public static int nextContainerCounter(EntityPlayer nmsPlayer) {
        try {
            return nmsPlayer.nextContainerCounter();
        }
        catch (NoSuchMethodError craftbukkitMethodNotFound) {
            RuntimeException ex = new RuntimeException("No method known of incrementing the player's container counter");
            ex.addSuppressed(craftbukkitMethodNotFound);
            throw ex;
        }
    }

    public static int slot(Slot slot) {
        try {
            return slot.index;
        }
        catch (IllegalAccessError | NoSuchFieldError craftbukkitFieldIsActuallyPrivate) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodHandle methodHandle = lookup.findVirtual(slot.getClass(), "getSlotIndex", MethodType.methodType(Integer.TYPE));
                return methodHandle.invoke(slot);
            }
            catch (Throwable forgeMethodNotFound) {
                RuntimeException ex = new RuntimeException("No method known of getting the slot's inventory index");
                ex.addSuppressed(craftbukkitFieldIsActuallyPrivate);
                ex.addSuppressed(forgeMethodNotFound);
                throw ex;
            }
        }
    }

    public static ItemStack[] enderChestItems(InventoryEnderChest enderChest) {
        try {
            return enderChest.items;
        }
        catch (IllegalAccessError | NoSuchFieldError craftbukkitFieldIsActuallyPrivate) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodHandle methodHandle = lookup.findVirtual(enderChest.getClass(), "getContents", MethodType.methodType(ItemStack[].class));
                return methodHandle.invoke(enderChest);
            }
            catch (Throwable forgeMethodNotFound) {
                RuntimeException ex = new RuntimeException("No method known of getting the enderchest items");
                ex.addSuppressed(craftbukkitFieldIsActuallyPrivate);
                ex.addSuppressed(forgeMethodNotFound);
                throw ex;
            }
        }
    }
}

