/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_8_R3;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.logging.DifferenceTracker;
import com.janboerman.invsee.spigot.api.logging.LogOptions;
import com.janboerman.invsee.spigot.api.logging.LogOutput;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.impl_1_8_R3.BootsSlot;
import com.janboerman.invsee.spigot.impl_1_8_R3.ChestplateSlot;
import com.janboerman.invsee.spigot.impl_1_8_R3.CursorSlot;
import com.janboerman.invsee.spigot.impl_1_8_R3.HelmetSlot;
import com.janboerman.invsee.spigot.impl_1_8_R3.InaccessiblePlaceholderSlot;
import com.janboerman.invsee.spigot.impl_1_8_R3.InvseeImpl;
import com.janboerman.invsee.spigot.impl_1_8_R3.LeggingsSlot;
import com.janboerman.invsee.spigot.impl_1_8_R3.MainBukkitInventoryView;
import com.janboerman.invsee.spigot.impl_1_8_R3.MainNmsInventory;
import com.janboerman.invsee.spigot.impl_1_8_R3.PersonalSlot;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.server.v1_8_R3.Container;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.IInventory;
import net.minecraft.server.v1_8_R3.PlayerInventory;
import net.minecraft.server.v1_8_R3.Slot;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

class MainNmsContainer
extends Container {
    final EntityHuman player;
    final MainNmsInventory top;
    final PlayerInventory bottom;
    final String title;
    final CreationOptions<PlayerInventorySlot> creationOptions;
    private final boolean spectatingOwnInventory;
    private MainBukkitInventoryView bukkitView;
    final DifferenceTracker tracker;

    private static Slot makeSlot(Mirror<PlayerInventorySlot> mirror, boolean spectatingOwnInventory, MainNmsInventory top, int positionIndex, int magicX, int magicY, net.minecraft.server.v1_8_R3.ItemStack inaccessiblePlaceholder) {
        PlayerInventorySlot place = mirror.getSlot(positionIndex);
        if (place == null) {
            return new InaccessiblePlaceholderSlot(inaccessiblePlaceholder, top, positionIndex, magicX, magicY);
        }
        if (place.isContainer()) {
            int referringTo = place.ordinal() - PlayerInventorySlot.CONTAINER_00.ordinal();
            return new Slot((IInventory)top, referringTo, magicX, magicY);
        }
        if (place == PlayerInventorySlot.ARMOUR_BOOTS) {
            int referringTo = 36;
            return new BootsSlot(top, 36, magicX, magicY);
        }
        if (place == PlayerInventorySlot.ARMOUR_LEGGINGS) {
            int referringTo = 37;
            return new LeggingsSlot(top, 37, magicX, magicY);
        }
        if (place == PlayerInventorySlot.ARMOUR_CHESTPLATE) {
            int referringTo = 38;
            return new ChestplateSlot(top, 38, magicX, magicY);
        }
        if (place == PlayerInventorySlot.ARMOUR_HELMET) {
            int referringTo = 39;
            return new HelmetSlot(top, 39, magicX, magicY);
        }
        if (place.isPersonal()) {
            int referringTo = place.ordinal() - PlayerInventorySlot.PERSONAL_00.ordinal() + 45;
            return new PersonalSlot(top, referringTo, magicX, magicY);
        }
        if (place.isCursor() && !spectatingOwnInventory) {
            int referringTo = 41;
            return new CursorSlot(top, 41, magicX, magicY);
        }
        return new InaccessiblePlaceholderSlot(inaccessiblePlaceholder, top, positionIndex, magicX, magicY);
    }

    public net.minecraft.server.v1_8_R3.ItemStack clickItem(int i, int j, int inventoryclicktype, EntityHuman entityhuman) {
        List<ItemStack> contentsBefore = null;
        if (this.tracker != null) {
            contentsBefore = Arrays.stream(this.top.getContents()).map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
        }
        net.minecraft.server.v1_8_R3.ItemStack result = super.clickItem(i, j, inventoryclicktype, entityhuman);
        if (this.tracker != null) {
            List<ItemStack> contentsAfter = Arrays.stream(this.top.getContents()).map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
            this.tracker.onClick(contentsBefore, contentsAfter);
        }
        return result;
    }

    public void b(EntityHuman entityhuman) {
        super.b(entityhuman);
        if (this.tracker != null && Objects.equals(entityhuman, this.player)) {
            this.tracker.onClose();
        }
    }

    MainNmsContainer(int containerId, MainNmsInventory nmsInventory, PlayerInventory playerInventory, EntityHuman player, CreationOptions<PlayerInventorySlot> creationOptions) {
        int magicY;
        int magicX;
        int index;
        int xPos;
        this.windowId = containerId;
        this.top = nmsInventory;
        this.bottom = playerInventory;
        this.player = player;
        this.spectatingOwnInventory = player.getUniqueID().equals(nmsInventory.targetPlayerUuid);
        nmsInventory.startOpen(player);
        this.creationOptions = creationOptions;
        this.title = creationOptions.getTitle().titleFor(Target.byGameProfile(nmsInventory.targetPlayerUuid, nmsInventory.targetPlayerName));
        Mirror<PlayerInventorySlot> mirror = creationOptions.getMirror();
        LogOptions logOptions = creationOptions.getLogOptions();
        Plugin plugin = creationOptions.getPlugin();
        if (!LogOptions.isEmpty(logOptions)) {
            this.tracker = new DifferenceTracker(LogOutput.make(plugin, player.getUniqueID(), player.getName(), Target.byGameProfile(nmsInventory.targetPlayerUuid, nmsInventory.targetPlayerName), logOptions), logOptions.getGranularity());
            this.tracker.onOpen();
        } else {
            this.tracker = null;
        }
        for (int yPos = 0; yPos < 6; ++yPos) {
            for (xPos = 0; xPos < 9; ++xPos) {
                index = xPos + yPos * 9;
                magicX = 8 + xPos * 18;
                magicY = 18 + yPos * 18;
                this.a(MainNmsContainer.makeSlot(mirror, this.spectatingOwnInventory, this.top, index, magicX, magicY, CraftItemStack.asNMSCopy((ItemStack)creationOptions.getPlaceholderPalette().inaccessible())));
            }
        }
        int magicAddY = 36;
        for (int yPos = 1; yPos < 4; ++yPos) {
            for (int xPos2 = 0; xPos2 < 9; ++xPos2) {
                int index2 = xPos2 + yPos * 9;
                int magicX2 = 8 + xPos2 * 18;
                int magicY2 = 103 + yPos * 18 + magicAddY;
                this.a(new Slot((IInventory)playerInventory, index2, magicX2, magicY2));
            }
        }
        for (xPos = 0; xPos < 9; ++xPos) {
            index = xPos;
            magicX = 8 + xPos * 18;
            magicY = 161 + magicAddY;
            this.a(new Slot((IInventory)playerInventory, index, magicX, magicY));
        }
    }

    public MainBukkitInventoryView getBukkitView() {
        if (this.bukkitView == null) {
            this.bukkitView = new MainBukkitInventoryView(this);
        }
        return this.bukkitView;
    }

    public boolean a(EntityHuman entityHuman) {
        return true;
    }

    public net.minecraft.server.v1_8_R3.ItemStack b(EntityHuman entityhuman, int rawIndex) {
        if (this.spectatingOwnInventory) {
            return InvseeImpl.EMPTY_STACK;
        }
        List slots = this.c;
        net.minecraft.server.v1_8_R3.ItemStack itemstack = InvseeImpl.EMPTY_STACK;
        Slot slot = (Slot)slots.get(rawIndex);
        int topRows = 6;
        if (slot != null && slot.hasItem()) {
            net.minecraft.server.v1_8_R3.ItemStack clickedSlotItem = slot.getItem();
            itemstack = clickedSlotItem.cloneItemStack();
            if (rawIndex < 54 ? !this.doShiftClickTransfer(clickedSlotItem, 54, slots.size(), true) : !this.doShiftClickTransfer(clickedSlotItem, 0, 54, false)) {
                return InvseeImpl.EMPTY_STACK;
            }
            if (clickedSlotItem.count == 0) {
                slot.set(InvseeImpl.EMPTY_STACK);
            } else {
                slot.f();
            }
            if (clickedSlotItem.count == itemstack.count) {
                return null;
            }
            slot.a(entityhuman, clickedSlotItem);
        }
        return itemstack;
    }

    private boolean doShiftClickTransfer(net.minecraft.server.v1_8_R3.ItemStack clickedSlotItem, int targetMinIndex, int targetMaxIndex, boolean topClicked) {
        return super.a(clickedSlotItem, targetMinIndex, targetMaxIndex, topClicked);
    }
}

