/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_8_R3;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.impl_1_8_R3.InvseeImpl;
import com.janboerman.invsee.spigot.impl_1_8_R3.MainBukkitInventory;
import com.janboerman.invsee.spigot.impl_1_8_R3.MainNmsContainer;
import com.janboerman.invsee.spigot.internal.inventory.AbstractNmsInventory;
import com.janboerman.invsee.utils.Ref;
import net.minecraft.server.v1_8_R3.Container;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.IChatBaseComponent;
import net.minecraft.server.v1_8_R3.IInventory;
import net.minecraft.server.v1_8_R3.ITileEntityContainer;
import net.minecraft.server.v1_8_R3.ItemStack;
import net.minecraft.server.v1_8_R3.PlayerInventory;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_8_R3.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

class MainNmsInventory
extends AbstractNmsInventory<PlayerInventorySlot, MainBukkitInventory, MainNmsInventory>
implements IInventory,
ITileEntityContainer {
    protected ItemStack[] storageContents;
    protected ItemStack[] armourContents;
    protected Ref<ItemStack> onCursor;
    protected ItemStack[] playerCraftingContents;
    private ItemStack[] personalContents;
    private int personalContentsSize;

    MainNmsInventory(EntityHuman target, CreationOptions<PlayerInventorySlot> creationOptions) {
        super(target.getUniqueID(), target.getName(), creationOptions);
        final PlayerInventory inv = target.inventory;
        this.storageContents = inv.items;
        this.armourContents = inv.armor;
        this.onCursor = new Ref<ItemStack>(){
            final /* synthetic */ MainNmsInventory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void set(ItemStack item) {
                inv.setCarried(item);
            }

            @Override
            public ItemStack get() {
                return inv.getCarried();
            }
        };
        IInventory playerCrafting = ((CraftInventory)target.defaultContainer.getBukkitView().getTopInventory()).getInventory();
        this.playerCraftingContents = playerCrafting.getContents();
        this.personalContents = this.playerCraftingContents;
    }

    void setPersonalContents(ItemStack[] personalContents, int size) {
        this.personalContents = personalContents;
        this.personalContentsSize = size;
    }

    void setPersonalContents(ItemStack[] personalContents) {
        this.setPersonalContents(personalContents, personalContents.length);
    }

    ItemStack[] getPersonalContents() {
        return this.personalContents;
    }

    int getPersonalContentsSize() {
        return this.personalContentsSize;
    }

    @Override
    protected MainBukkitInventory createBukkit() {
        return new MainBukkitInventory(this);
    }

    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public int defaultMaxStack() {
        return 64;
    }

    @Override
    public void shallowCopyFrom(MainNmsInventory from) {
        this.setMaxStackSize(from.getMaxStackSize());
        this.storageContents = from.storageContents;
        this.armourContents = from.armourContents;
        this.onCursor = from.onCursor;
        this.playerCraftingContents = from.playerCraftingContents;
        this.personalContents = from.personalContents;
        this.personalContentsSize = from.personalContentsSize;
        this.update();
    }

    private Ref<ItemStack> decideWhichItem(int slot) {
        int idx;
        int storageSize = this.storageContents.length;
        if (0 <= slot && slot < storageSize) {
            int idx2 = slot;
            return Ref.ofArray(idx2, this.storageContents);
        }
        int armourSize = this.armourContents.length;
        if (storageSize <= slot && slot < storageSize + armourSize) {
            int idx3 = slot - storageSize;
            return Ref.ofArray(idx3, this.armourContents);
        }
        int offhandSize = 1;
        if (storageSize + armourSize + offhandSize == slot) {
            return this.onCursor;
        }
        if (45 <= slot && slot < 54 && (idx = slot - 45) < this.personalContentsSize) {
            return Ref.ofArray(idx, this.personalContents);
        }
        return null;
    }

    public int getSize() {
        return 54;
    }

    public ItemStack getItem(int slot) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return InvseeImpl.EMPTY_STACK;
        }
        return ref.get();
    }

    public ItemStack splitStack(int slot, int subtractAmount) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return InvseeImpl.EMPTY_STACK;
        }
        ItemStack stack = ref.get();
        if (!InvseeImpl.isEmptyStack(stack) && subtractAmount > 0) {
            ItemStack oldStackCopy = ref.get().cloneAndSubtract(subtractAmount);
            if (InvseeImpl.isEmptyStack(oldStackCopy)) {
                this.update();
            }
            return oldStackCopy;
        }
        return InvseeImpl.EMPTY_STACK;
    }

    public ItemStack splitWithoutUpdate(int slot) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return InvseeImpl.EMPTY_STACK;
        }
        ItemStack stack = ref.get();
        if (InvseeImpl.isEmptyStack(stack)) {
            return InvseeImpl.EMPTY_STACK;
        }
        ref.set(InvseeImpl.EMPTY_STACK);
        return stack;
    }

    public void setItem(int slot, ItemStack itemStack) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return;
        }
        ref.set(itemStack);
        if (!InvseeImpl.isEmptyStack(itemStack) && itemStack.count > this.getMaxStackSize()) {
            itemStack.count = this.getMaxStackSize();
        }
        this.update();
    }

    public void update() {
        for (HumanEntity viewer : this.getViewers()) {
            if (!(viewer instanceof Player)) continue;
            ((Player)viewer).updateInventory();
        }
    }

    public boolean a(EntityHuman entityHuman) {
        return true;
    }

    public void startOpen(EntityHuman entityHuman) {
        this.onOpen(entityHuman.getBukkitEntity());
    }

    public void closeContainer(EntityHuman entityHuman) {
        this.onClose(entityHuman.getBukkitEntity());
    }

    public boolean b(int slot, ItemStack itemStack) {
        return true;
    }

    public int getProperty(int idx) {
        return 0;
    }

    public void b(int idx, int value) {
    }

    public int g() {
        return 0;
    }

    public ItemStack[] getContents() {
        ItemStack[] result = new ItemStack[this.getSize()];
        System.arraycopy(this.storageContents, 0, result, PlayerInventorySlot.CONTAINER_00.defaultIndex(), this.storageContents.length);
        System.arraycopy(this.armourContents, 0, result, PlayerInventorySlot.ARMOUR_BOOTS.defaultIndex(), this.armourContents.length);
        result[PlayerInventorySlot.CURSOR.defaultIndex()] = this.onCursor.get();
        System.arraycopy(this.personalContents, 0, result, PlayerInventorySlot.PERSONAL_00.defaultIndex(), this.personalContentsSize);
        return result;
    }

    public void onOpen(CraftHumanEntity who) {
        super.onOpen((HumanEntity)who);
    }

    public void onClose(CraftHumanEntity who) {
        super.onClose((HumanEntity)who);
    }

    public void l() {
        InvseeImpl.clear(this.storageContents);
        InvseeImpl.clear(this.armourContents);
        this.onCursor.set(InvseeImpl.EMPTY_STACK);
        InvseeImpl.clear(this.personalContents);
        if (this.personalContents != this.playerCraftingContents) {
            InvseeImpl.clear(this.playerCraftingContents);
        }
    }

    public Container createContainer(PlayerInventory playerInventory, EntityHuman entityHuman) {
        EntityPlayer entityPlayer = (EntityPlayer)entityHuman;
        return new MainNmsContainer(entityPlayer.nextContainerCounter(), this, playerInventory, entityHuman, this.creationOptions);
    }

    public String getContainerName() {
        return "minecraft:container";
    }

    public String getName() {
        return this.creationOptions.getTitle().titleFor(Target.byGameProfile(this.targetPlayerUuid, this.targetPlayerName));
    }

    public boolean hasCustomName() {
        return this.creationOptions.getTitle() != null;
    }

    public IChatBaseComponent getScoreboardDisplayName() {
        return CraftChatMessage.fromString((String)this.creationOptions.getTitle().titleFor(Target.byGameProfile(this.targetPlayerUuid, this.targetPlayerName)))[0];
    }
}

