/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_8_R3;

import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.resolve.NameResolveStrategy;
import com.janboerman.invsee.spigot.impl_1_8_R3.HybridServerSupport;
import com.janboerman.invsee.spigot.internal.CompletedEmpty;
import java.io.File;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.WorldNBTStorage;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.plugin.Plugin;

public class NameSearchSaveFilesStrategy
implements NameResolveStrategy {
    private final Plugin plugin;
    private final Scheduler scheduler;

    public NameSearchSaveFilesStrategy(Plugin plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
    }

    @Override
    public CompletableFuture<Optional<String>> resolveUserName(UUID uniqueId) {
        CraftServer craftServer = (CraftServer)this.plugin.getServer();
        WorldNBTStorage worldNBTStorage = (WorldNBTStorage)craftServer.getHandle().playerFileData;
        File playerDirectory = HybridServerSupport.getPlayerDir(worldNBTStorage);
        if (!playerDirectory.exists() || !playerDirectory.isDirectory()) {
            return CompletedEmpty.the();
        }
        return CompletableFuture.supplyAsync(() -> {
            NBTTagCompound bukkit;
            NBTTagCompound compound = worldNBTStorage.getPlayerData(uniqueId.toString());
            if (compound.hasKeyOfType("bukkit", 10) && (bukkit = compound.getCompound("bukkit")).hasKeyOfType("lastKnownName", 8)) {
                String lastKnownName = bukkit.getString("lastKnownName");
                return Optional.of(lastKnownName);
            }
            return Optional.empty();
        }, this.scheduler::executeAsync);
    }
}

