/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.internal;

import com.janboerman.invsee.mojangapi.MojangAPI;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.resolve.NameInMemoryStrategy;
import com.janboerman.invsee.spigot.api.resolve.NameMojangAPIStrategy;
import com.janboerman.invsee.spigot.api.resolve.NameOnlinePlayerStrategy;
import com.janboerman.invsee.spigot.api.resolve.NamePermissionPluginStrategy;
import com.janboerman.invsee.spigot.api.resolve.NameResolveStrategy;
import com.janboerman.invsee.spigot.api.resolve.UUIDBungeeCordStrategy;
import com.janboerman.invsee.spigot.api.resolve.UUIDInMemoryStrategy;
import com.janboerman.invsee.spigot.api.resolve.UUIDMojangAPIStrategy;
import com.janboerman.invsee.spigot.api.resolve.UUIDOfflineModeStrategy;
import com.janboerman.invsee.spigot.api.resolve.UUIDOnlinePlayerStrategy;
import com.janboerman.invsee.spigot.api.resolve.UUIDPaperCacheStrategy;
import com.janboerman.invsee.spigot.api.resolve.UUIDPermissionPluginStrategy;
import com.janboerman.invsee.spigot.api.resolve.UUIDResolveStrategy;
import com.janboerman.invsee.spigot.internal.CompletedEmpty;
import com.janboerman.invsee.utils.CaseInsensitiveMap;
import com.janboerman.invsee.utils.Maybe;
import com.janboerman.invsee.utils.SynchronizedIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.Server;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class NamesAndUUIDs {
    protected static final boolean SPIGOT;
    protected static final boolean PAPER;
    private final Map<String, UUID> uuidCache = Collections.synchronizedMap(new CaseInsensitiveMap<UUID>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, UUID> eldest) {
            return this.size() > 200;
        }
    });
    private final Map<String, UUID> uuidCacheView = Collections.unmodifiableMap(this.uuidCache);
    private final Map<UUID, String> userNameCache = Collections.synchronizedMap(new LinkedHashMap<UUID, String>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<UUID, String> eldest) {
            return this.size() > 200;
        }
    });
    private final Map<UUID, String> userNameCacheView = Collections.unmodifiableMap(this.userNameCache);
    public final List<UUIDResolveStrategy> uuidResolveStrategies;
    public final List<NameResolveStrategy> nameResolveStrategies;
    private boolean bungeeCord = false;
    private boolean bungeeCordOnline = false;
    private boolean velocity = false;
    private boolean velocityOnline = false;

    @Deprecated
    public NamesAndUUIDs(Plugin plugin, Scheduler scheduler) {
        YamlConfiguration spigotConfig;
        ConfigurationSection settings;
        MojangAPI mojangApi = new MojangAPI(scheduler::executeAsync);
        this.uuidResolveStrategies = Collections.synchronizedList(new ArrayList(10));
        this.nameResolveStrategies = Collections.synchronizedList(new ArrayList(10));
        this.uuidResolveStrategies.add(new UUIDOnlinePlayerStrategy(plugin.getServer(), scheduler::executeSyncGlobal));
        this.nameResolveStrategies.add(new NameOnlinePlayerStrategy(plugin.getServer(), scheduler::executeSyncGlobal));
        this.uuidResolveStrategies.add(new UUIDInMemoryStrategy(this.uuidCache));
        this.nameResolveStrategies.add(new NameInMemoryStrategy(this.userNameCache));
        if (SPIGOT && (settings = (spigotConfig = plugin.getServer().spigot().getConfig()).getConfigurationSection("settings")) != null) {
            this.bungeeCord = this.bungeeCordOnline = settings.getBoolean("bungeecord", false);
        }
        if (PAPER) {
            this.uuidResolveStrategies.add(new UUIDPaperCacheStrategy(plugin, scheduler));
            try {
                YamlConfiguration paperConfig = plugin.getServer().spigot().getPaperConfig();
                ConfigurationSection proxiesSection = paperConfig.getConfigurationSection("proxies");
                if (proxiesSection != null) {
                    ConfigurationSection velocitySection;
                    ConfigurationSection bungeeSection = proxiesSection.getConfigurationSection("bungee-cord");
                    if (bungeeSection != null) {
                        boolean bl = this.bungeeCordOnline = this.bungeeCord && bungeeSection.getBoolean("online-mode", false);
                    }
                    if ((velocitySection = proxiesSection.getConfigurationSection("velocity")) != null) {
                        this.velocity = velocitySection.getBoolean("enabled", false);
                        this.velocityOnline = this.velocity && velocitySection.getBoolean("online-mode", false);
                    }
                }
            }
            catch (UnsupportedOperationException e) {
                plugin.getLogger().log(Level.WARNING, "Server acts as if it supports the paper config api, but it actually doesn't!", e);
            }
        }
        this.uuidResolveStrategies.add(new UUIDPermissionPluginStrategy(plugin, scheduler));
        this.nameResolveStrategies.add(new NamePermissionPluginStrategy(plugin, scheduler));
        if (this.bungeeCord || this.velocity) {
            this.uuidResolveStrategies.add(new UUIDBungeeCordStrategy(plugin, scheduler));
        }
        if (this.onlineMode(plugin.getServer())) {
            this.uuidResolveStrategies.add(new UUIDMojangAPIStrategy(plugin, mojangApi));
            this.nameResolveStrategies.add(new NameMojangAPIStrategy(plugin, mojangApi));
        } else {
            this.uuidResolveStrategies.add(new UUIDOfflineModeStrategy());
        }
    }

    public final boolean onlineMode(Server server) {
        return server.getOnlineMode() || this.bungeeCordOnline || this.velocityOnline;
    }

    public Map<String, UUID> getUuidCache() {
        return this.uuidCacheView;
    }

    public Map<UUID, String> getUserNameCache() {
        return this.userNameCacheView;
    }

    public void cacheNameAndUniqueId(UUID uuid, String userName) {
        this.userNameCache.put(uuid, userName);
        this.uuidCache.put(userName, uuid);
    }

    public CompletableFuture<Optional<UUID>> resolveUUID(String username) {
        CompletableFuture<Optional<UUID>> result = NamesAndUUIDs.resolveUUID(username, new SynchronizedIterator<UUIDResolveStrategy>(this.uuidResolveStrategies.iterator()));
        result.thenAccept(optUuid -> optUuid.ifPresent(uuid -> this.cacheNameAndUniqueId((UUID)uuid, username)));
        return result;
    }

    public CompletableFuture<Optional<String>> resolveUserName(UUID uniqueId) {
        CompletableFuture<Optional<String>> result = NamesAndUUIDs.resolveUserName(uniqueId, new SynchronizedIterator<NameResolveStrategy>(this.nameResolveStrategies.iterator()));
        result.thenAccept(optName -> optName.ifPresent(name -> this.cacheNameAndUniqueId(uniqueId, (String)name)));
        return result;
    }

    private static CompletableFuture<Optional<UUID>> resolveUUID(String userName, SynchronizedIterator<UUIDResolveStrategy> strategies) {
        Maybe<UUIDResolveStrategy> maybeStrat = strategies.moveNext();
        if (!maybeStrat.isPresent()) {
            return CompletedEmpty.the();
        }
        UUIDResolveStrategy strategy = maybeStrat.get();
        return strategy.resolveUniqueId(userName).thenCompose(optionalUuid -> {
            if (optionalUuid.isPresent()) {
                return CompletableFuture.completedFuture(optionalUuid);
            }
            return NamesAndUUIDs.resolveUUID(userName, strategies);
        });
    }

    private static CompletableFuture<Optional<String>> resolveUserName(UUID uniqueId, SynchronizedIterator<NameResolveStrategy> strategies) {
        Maybe<NameResolveStrategy> maybeStrat = strategies.moveNext();
        if (!maybeStrat.isPresent()) {
            return CompletedEmpty.the();
        }
        NameResolveStrategy strategy = maybeStrat.get();
        return strategy.resolveUserName(uniqueId).thenCompose(optionalName -> {
            if (optionalName.isPresent()) {
                return CompletableFuture.completedFuture(optionalName);
            }
            return NamesAndUUIDs.resolveUserName(uniqueId, strategies);
        });
    }

    static {
        boolean paperParticleBuilder;
        boolean configExists;
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            configExists = true;
        }
        catch (ClassNotFoundException e) {
            configExists = false;
        }
        SPIGOT = configExists;
        try {
            Class.forName("com.destroystokyo.paper.ParticleBuilder");
            paperParticleBuilder = true;
        }
        catch (ClassNotFoundException e) {
            paperParticleBuilder = false;
        }
        PAPER = paperParticleBuilder;
    }
}

