/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.internal;

import com.janboerman.invsee.spigot.api.EnderSpectatorInventory;
import com.janboerman.invsee.spigot.api.MainSpectatorInventory;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;

public class OpenSpectatorsCache {
    private Map<UUID, WeakReference<MainSpectatorInventory>> openInventories = Collections.synchronizedMap(new WeakHashMap());
    private Map<UUID, WeakReference<EnderSpectatorInventory>> openEnderChests = Collections.synchronizedMap(new WeakHashMap());

    public void cache(MainSpectatorInventory spectatorInventory) {
        this.cache(spectatorInventory, false);
    }

    public void cache(MainSpectatorInventory spectatorInventory, boolean force) {
        MainSpectatorInventory oldSpectatorInv;
        WeakReference<MainSpectatorInventory> ref;
        if (force || (ref = this.openInventories.get(spectatorInventory.getSpectatedPlayerId())) == null || (oldSpectatorInv = (MainSpectatorInventory)ref.get()) == null) {
            this.openInventories.put(spectatorInventory.getSpectatedPlayerId(), new WeakReference<MainSpectatorInventory>(spectatorInventory));
        }
    }

    public void cache(EnderSpectatorInventory spectatorInventory) {
        this.cache(spectatorInventory, false);
    }

    public void cache(EnderSpectatorInventory spectatorInventory, boolean force) {
        EnderSpectatorInventory oldSpectatorInv;
        WeakReference<EnderSpectatorInventory> ref;
        if (force || (ref = this.openEnderChests.get(spectatorInventory.getSpectatedPlayerId())) == null || (oldSpectatorInv = (EnderSpectatorInventory)ref.get()) == null) {
            this.openEnderChests.put(spectatorInventory.getSpectatedPlayerId(), new WeakReference<EnderSpectatorInventory>(spectatorInventory));
        }
    }

    public MainSpectatorInventory getMainSpectatorInventory(UUID targetPlayerId) {
        WeakReference<MainSpectatorInventory> ref = this.openInventories.get(targetPlayerId);
        if (ref == null) {
            return null;
        }
        return (MainSpectatorInventory)ref.get();
    }

    public EnderSpectatorInventory getEnderSpectatorInventory(UUID targetPlayerId) {
        WeakReference<EnderSpectatorInventory> ref = this.openEnderChests.get(targetPlayerId);
        if (ref == null) {
            return null;
        }
        return (EnderSpectatorInventory)ref.get();
    }
}

