/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.perworldinventory;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.jetbrains.annotations.NotNull;

public class FakeAttributeInstance
implements AttributeInstance {
    private final Attribute attribute;
    private double baseValue;
    private final Collection<AttributeModifier> modifiers = new TreeSet<AttributeModifier>(Comparator.comparing(AttributeModifier::getOperation).thenComparing(AttributeModifier::getUniqueId));

    public FakeAttributeInstance(Attribute attribute) {
        this.attribute = attribute;
        this.baseValue = this.getDefaultValue();
    }

    @NotNull
    public Attribute getAttribute() {
        return this.attribute;
    }

    public double getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(double v) {
        this.baseValue = v;
    }

    @NotNull
    public Collection<AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    public void addModifier(@NotNull AttributeModifier attributeModifier) {
        this.modifiers.add(attributeModifier);
    }

    public void removeModifier(@NotNull AttributeModifier attributeModifier) {
        this.modifiers.remove(attributeModifier);
    }

    public double getValue() {
        double x = this.getBaseValue();
        double y = -1.0;
        AttributeModifier.Operation lastOperation = null;
        for (AttributeModifier modifier : this.getModifiers()) {
            AttributeModifier.Operation operation = modifier.getOperation();
            if (lastOperation == AttributeModifier.Operation.ADD_NUMBER && operation == AttributeModifier.Operation.ADD_SCALAR) {
                y = x;
            }
            double byAmount = modifier.getAmount();
            switch (operation) {
                case ADD_NUMBER: {
                    x += byAmount;
                    break;
                }
                case ADD_SCALAR: {
                    y += x * byAmount;
                    break;
                }
                case MULTIPLY_SCALAR_1: {
                    y *= 1.0 + byAmount;
                }
            }
            lastOperation = operation;
        }
        switch (this.getAttribute()) {
            case GENERIC_ATTACK_KNOCKBACK: {
                y = FakeAttributeInstance.between(0.0, y, 8.0);
            }
            case GENERIC_ARMOR: {
                y = FakeAttributeInstance.between(0.0, y, 30.0);
                break;
            }
            case GENERIC_ARMOR_TOUGHNESS: {
                y = FakeAttributeInstance.between(0.0, y, 20.0);
                break;
            }
            case GENERIC_ATTACK_DAMAGE: {
                y = FakeAttributeInstance.between(0.0, y, 2048.0);
                break;
            }
            case GENERIC_ATTACK_SPEED: {
                y = FakeAttributeInstance.between(0.0, y, 1024.0);
                break;
            }
            case GENERIC_FLYING_SPEED: {
                y = FakeAttributeInstance.between(0.0, y, 1024.0);
                break;
            }
            case GENERIC_FOLLOW_RANGE: {
                y = FakeAttributeInstance.between(0.0, y, 2048.0);
                break;
            }
            case GENERIC_KNOCKBACK_RESISTANCE: {
                y = FakeAttributeInstance.between(0.0, y, 1.0);
                break;
            }
            case GENERIC_LUCK: {
                y = FakeAttributeInstance.between(-1024.0, y, 1024.0);
                break;
            }
            case GENERIC_MAX_HEALTH: {
                y = FakeAttributeInstance.between(0.0, y, 1024.0);
                break;
            }
            case GENERIC_MOVEMENT_SPEED: {
                y = FakeAttributeInstance.between(0.0, y, 1024.0);
                break;
            }
            case HORSE_JUMP_STRENGTH: {
                y = FakeAttributeInstance.between(0.0, y, 2.0);
                break;
            }
            case ZOMBIE_SPAWN_REINFORCEMENTS: {
                y = FakeAttributeInstance.between(0.0, y, 1.0);
                break;
            }
            default: {
                y = FakeAttributeInstance.between(Double.MIN_NORMAL, y, Double.MAX_VALUE);
            }
        }
        return y;
    }

    public double getDefaultValue() {
        switch (this.getAttribute()) {
            case GENERIC_MAX_HEALTH: {
                return 20.0;
            }
            case GENERIC_FOLLOW_RANGE: {
                return 32.0;
            }
            case GENERIC_KNOCKBACK_RESISTANCE: {
                return 0.0;
            }
            case GENERIC_MOVEMENT_SPEED: {
                return 0.7;
            }
            case GENERIC_ATTACK_DAMAGE: {
                return 1.0;
            }
            case GENERIC_ARMOR: {
                return 0.0;
            }
            case GENERIC_ARMOR_TOUGHNESS: {
                return 0.0;
            }
            case GENERIC_ATTACK_SPEED: {
                return 4.0;
            }
            case GENERIC_LUCK: {
                return 0.0;
            }
            case HORSE_JUMP_STRENGTH: {
                return 0.7;
            }
            case GENERIC_FLYING_SPEED: {
                return 0.4;
            }
            case ZOMBIE_SPAWN_REINFORCEMENTS: {
                return 0.0;
            }
            case GENERIC_ATTACK_KNOCKBACK: {
                return 0.0;
            }
        }
        return 0.0;
    }

    private static double between(double min, double value, double max) {
        return Math.min(Math.max(min, value), max);
    }
}

