/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.perworldinventory;

import com.janboerman.invsee.spigot.internal.FakePersistentDataContainer;
import com.janboerman.invsee.spigot.perworldinventory.FakeAttributeInstance;
import com.janboerman.invsee.spigot.perworldinventory.FakeInventory;
import com.janboerman.invsee.spigot.perworldinventory.FakePlayerInventory;
import com.janboerman.invsee.spigot.perworldinventory.FakePlayerProfile;
import com.janboerman.invsee.utils.Compat;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Trident;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakePlayer
implements Player {
    private final Server server;
    private final UUID uuid;
    private final String name;
    private String displayName;
    private String playerListName;
    private String playerListHeader;
    private String playerListFooter;
    private Location compassTarget;
    private Location location;
    private int fireTicks;
    private boolean persistent;
    private Entity passenger;
    private Entity vehicle;
    private float fallDistance;
    private EntityDamageEvent lastDamageCause;
    private int ticksLived;
    private boolean customNameVisible;
    private boolean glowing;
    private boolean invulnerable;
    private boolean silent;
    private int portalCooldown;
    private boolean sneaking;
    private boolean sprinting;
    private boolean sleepingIgnored;
    private EnumMap<Statistic, Integer> statistics = new EnumMap(Statistic.class);
    private Location bedSpawnLocation;
    private long playerTime;
    private WeatherType weatherType;
    private int level;
    private float exp;
    private Integer totalExperience;
    private float exhaustion;
    private float saturation;
    private int foodLevel;
    private boolean allowFlight;
    private boolean flying;
    private float flySpeed;
    private float walkSpeed;
    private Scoreboard scoreboard;
    private boolean healthScaled;
    private double healthScale;
    private Entity spectatorTarget;
    private int clientViewDistance;
    private MainHand mainHand = MainHand.RIGHT;
    private ItemStack itemOnCursor;
    private EnumMap<Material, Integer> cooldowns = new EnumMap(Material.class);
    private GameMode gameMode;
    private Set<NamespacedKey> discoveredRecipes = new HashSet<NamespacedKey>();
    private Entity leftShoulder;
    private Entity rightShoulder;
    private Integer remainingAir;
    private Integer maximumAir;
    private int maximumNoDamageTicks;
    private Double lastDamage;
    private int noDamageTicks;
    private Map<PotionEffectType, PotionEffect> potionEffects = new HashMap<PotionEffectType, PotionEffect>();
    private boolean removeWhenFarAway;
    private boolean canPickupItems;
    private Entity leashHolder;
    private boolean gliding;
    private boolean swimming;
    private boolean collidable;
    private Map<MemoryKey<?>, Object> memory = new HashMap();
    private double health;
    private double absorptionAmount;
    private String customName;
    private HashMap<String, Map<Plugin, MetadataValue>> metadata = new HashMap();
    private final PermissibleBase permissible;
    private boolean operator;
    private PersistentDataContainer persistentDataContainer;
    private final FakeInventory enderChest;
    private final FakePlayerInventory inventory;
    private final EnumMap<Attribute, AttributeInstance> attributes = new EnumMap(Attribute.class);
    private final long firstPlayed;
    private final long lastPlayed;
    private int arrowsInBody;
    private int arrowCooldown;
    private boolean invisible;
    private int starvationRate = 80;
    private int unsaturatedRegenerationRate = 80;
    private int saturatedRegenerationRate = 10;
    private boolean visualFire = true;
    private int freezeTicks;
    private boolean gravity;
    private GameMode previousGameMode;
    private final WeakHashMap<Plugin, Set<Entity>> hiddenEntities = new WeakHashMap();
    private WorldBorder worldBorder;
    private Location lastDeathLocation;
    private int enchantmentSeed;
    private boolean visibleByDefault;
    private int expCooldown;

    public FakePlayer(UUID uniqueId, String name, Server server) {
        this.uuid = uniqueId;
        this.name = name;
        this.server = server;
        this.setDisplayName(name);
        this.setPlayerListName(name);
        this.setGameMode(server.getDefaultGameMode());
        this.permissible = new PermissibleBase((ServerOperator)this);
        this.enderChest = new FakeInventory(InventoryType.ENDER_CHEST, new ItemStack[27], (InventoryHolder)this);
        this.inventory = new FakePlayerInventory(new ItemStack[41], (HumanEntity)this);
        this.clientViewDistance = server.getViewDistance();
        this.registerAttribute(Attribute.GENERIC_MAX_HEALTH);
        this.registerAttribute(Attribute.GENERIC_FOLLOW_RANGE);
        this.registerAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE);
        this.registerAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.1);
        this.registerAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        this.registerAttribute(Attribute.GENERIC_ARMOR);
        this.registerAttribute(Attribute.GENERIC_ARMOR_TOUGHNESS);
        try {
            this.registerAttribute(Attribute.valueOf((String)"GENERIC_ATTACK_KNOCKBACK"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.registerAttribute(Attribute.GENERIC_ATTACK_SPEED);
        this.registerAttribute(Attribute.GENERIC_LUCK);
        this.firstPlayed = 0L;
        this.lastPlayed = System.currentTimeMillis();
    }

    private AttributeInstance registerAttribute(Attribute attribute) {
        FakeAttributeInstance instance = new FakeAttributeInstance(attribute);
        this.attributes.put(attribute, instance);
        return instance;
    }

    @NotNull
    public String getDisplayName() {
        return this.name;
    }

    public void setDisplayName(@Nullable String s) {
        this.displayName = s;
    }

    @NotNull
    public String getPlayerListName() {
        return this.playerListName;
    }

    public void setPlayerListName(@Nullable String s) {
        this.playerListName = s;
    }

    @Nullable
    public String getPlayerListHeader() {
        return this.playerListHeader;
    }

    @Nullable
    public String getPlayerListFooter() {
        return this.playerListFooter;
    }

    public void setPlayerListHeader(@Nullable String s) {
        this.playerListHeader = s;
    }

    public void setPlayerListFooter(@Nullable String s) {
        this.playerListFooter = s;
    }

    public void setPlayerListHeaderFooter(@Nullable String s, @Nullable String s1) {
        this.setPlayerListHeader(s);
        this.setPlayerListFooter(s1);
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    public void setCompassTarget(@NotNull Location location) {
        this.compassTarget = location;
    }

    @NotNull
    public Location getCompassTarget() {
        if (this.compassTarget == null) {
            return this.getBedSpawnLocation();
        }
        return this.compassTarget;
    }

    @Nullable
    public InetSocketAddress getAddress() {
        return null;
    }

    public int getPing() {
        return 0;
    }

    public boolean isConversing() {
        return false;
    }

    public void acceptConversationInput(@NotNull String s) {
    }

    public boolean beginConversation(@NotNull Conversation conversation) {
        return false;
    }

    public void abandonConversation(@NotNull Conversation conversation) {
    }

    public void abandonConversation(@NotNull Conversation conversation, @NotNull ConversationAbandonedEvent conversationAbandonedEvent) {
    }

    public void sendRawMessage(@NotNull String s) {
    }

    public void sendRawMessage(UUID from, String s) {
    }

    public void kickPlayer(@Nullable String s) {
    }

    public void chat(@NotNull String s) {
    }

    public boolean performCommand(@NotNull String s) {
        return false;
    }

    @NotNull
    public Location getLocation() {
        if (this.location == null) {
            return this.getBedLocation();
        }
        return this.location;
    }

    @Nullable
    public Location getLocation(@Nullable Location location) {
        if (location == null || this.location == null) {
            return null;
        }
        location.setX(this.location.getX());
        location.setY(this.location.getY());
        location.setZ(this.location.getZ());
        location.setYaw(this.location.getYaw());
        location.setPitch(this.location.getPitch());
        location.setWorld(this.location.getWorld());
        return location;
    }

    public void setVelocity(@NotNull Vector vector) {
    }

    @NotNull
    public Vector getVelocity() {
        return new Vector(0, 0, 0);
    }

    public double getHeight() {
        if (this.isSleeping()) {
            return 0.2;
        }
        if (this.isSwimming()) {
            return 0.6;
        }
        if (this.isSneaking()) {
            return 1.5;
        }
        return 1.8;
    }

    public double getWidth() {
        if (this.isSleeping()) {
            return 0.2;
        }
        return 0.6;
    }

    @NotNull
    public BoundingBox getBoundingBox() {
        double halfWidth = this.getWidth() / 2.0;
        Location loc = this.getLocation();
        double minX = loc.getX() - halfWidth;
        double maxX = loc.getX() + halfWidth;
        double minZ = loc.getZ() - halfWidth;
        double maxZ = loc.getZ() + halfWidth;
        double minY = loc.getY();
        double maxY = loc.getY() + this.getHeight();
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean isOnGround() {
        return false;
    }

    public boolean isInWater() {
        Material blockType = this.getLocation().getBlock().getType();
        switch (blockType) {
            case WATER: {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public World getWorld() {
        return this.getLocation().getWorld();
    }

    public void setRotation(float v, float v1) {
        if (this.location == null) {
            this.location = this.getLocation().clone();
        }
        this.location.setYaw(v);
        this.location.setPitch(v1);
    }

    public boolean teleport(@NotNull Location location) {
        this.location = location.clone();
        return true;
    }

    public boolean teleport(@NotNull Location location, @NotNull PlayerTeleportEvent.TeleportCause teleportCause) {
        return this.teleport(location);
    }

    public boolean teleport(@NotNull Entity entity) {
        return this.teleport(entity.getLocation());
    }

    public boolean teleport(@NotNull Entity entity, @NotNull PlayerTeleportEvent.TeleportCause teleportCause) {
        return this.teleport(entity.getLocation(), teleportCause);
    }

    @NotNull
    public List<Entity> getNearbyEntities(double v, double v1, double v2) {
        return Compat.listCopy(this.getWorld().getNearbyEntities(this.getLocation(), v, v1, v2));
    }

    public int getEntityId() {
        return -1;
    }

    public int getFireTicks() {
        return this.fireTicks;
    }

    public int getMaxFireTicks() {
        return 16;
    }

    public void setFireTicks(int i) {
        this.fireTicks = i;
    }

    public void setVisualFire(boolean b) {
        this.visualFire = b;
    }

    public boolean isVisualFire() {
        return this.visualFire;
    }

    public int getFreezeTicks() {
        return this.freezeTicks;
    }

    public int getMaxFreezeTicks() {
        return Integer.MAX_VALUE;
    }

    public void setFreezeTicks(int i) {
        this.freezeTicks = i;
    }

    public boolean isFrozen() {
        return this.freezeTicks > 0;
    }

    public void remove() {
    }

    public boolean isDead() {
        return false;
    }

    public boolean isValid() {
        return false;
    }

    public void sendMessage(@NotNull String message) {
    }

    public void sendMessage(@NotNull String[] messages) {
    }

    public void sendMessage(UUID from, String message) {
    }

    public void sendMessage(UUID from, String[] messages) {
    }

    @NotNull
    public Server getServer() {
        return this.server;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean b) {
        this.persistent = b;
    }

    @Nullable
    public Entity getPassenger() {
        return this.passenger;
    }

    public boolean setPassenger(@NotNull Entity entity) {
        if (entity != this) {
            this.passenger = entity;
            return true;
        }
        return false;
    }

    @NotNull
    public List<Entity> getPassengers() {
        ArrayList<Entity> passengers = new ArrayList<Entity>(0);
        Entity passenger = this.getPassenger();
        if (passenger != null) {
            passengers.add(passenger);
            passengers.addAll(passenger.getPassengers());
        }
        return passengers;
    }

    public boolean addPassenger(@NotNull Entity entity) {
        Entity passenger = this.getPassenger();
        if (passenger == null) {
            return this.setPassenger(entity);
        }
        return passenger.addPassenger(entity);
    }

    public boolean removePassenger(@NotNull Entity entity) {
        Entity passenger = this.getPassenger();
        if (passenger == null) {
            return false;
        }
        if (Objects.equals(passenger, entity)) {
            this.eject();
            return true;
        }
        return passenger.removePassenger(entity);
    }

    public boolean isEmpty() {
        return this.getPassenger() == null;
    }

    public boolean eject() {
        boolean ejected = this.passenger != null;
        this.passenger = null;
        return ejected;
    }

    public float getFallDistance() {
        return this.fallDistance;
    }

    public void setFallDistance(float v) {
        this.fallDistance = v;
    }

    public void setLastDamageCause(@Nullable EntityDamageEvent entityDamageEvent) {
        this.lastDamageCause = entityDamageEvent;
    }

    @Nullable
    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageCause;
    }

    @NotNull
    public UUID getUniqueId() {
        return this.uuid;
    }

    @NotNull
    public PlayerProfile getPlayerProfile() {
        return new FakePlayerProfile(this);
    }

    public int getTicksLived() {
        return this.ticksLived;
    }

    public void setTicksLived(int i) {
        this.ticksLived = i;
    }

    public void playEffect(@NotNull EntityEffect entityEffect) {
    }

    @NotNull
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    @NotNull
    public Sound getSwimSound() {
        return null;
    }

    @NotNull
    public Sound getSwimSplashSound() {
        return null;
    }

    @NotNull
    public Sound getSwimHighSpeedSplashSound() {
        return null;
    }

    public boolean isInsideVehicle() {
        return this.getVehicle() != null;
    }

    public boolean leaveVehicle() {
        boolean result = this.isInsideVehicle();
        this.vehicle = null;
        return result;
    }

    @Nullable
    public Entity getVehicle() {
        return this.vehicle;
    }

    public void setCustomNameVisible(boolean b) {
        this.customNameVisible = b;
    }

    public boolean isCustomNameVisible() {
        return this.customNameVisible;
    }

    public void setVisibleByDefault(boolean b) {
        this.visibleByDefault = b;
    }

    public boolean isVisibleByDefault() {
        return this.visibleByDefault;
    }

    public void setGlowing(boolean b) {
        this.glowing = b;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setInvulnerable(boolean b) {
        this.invulnerable = b;
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean b) {
        this.silent = b;
    }

    public boolean hasGravity() {
        return this.gravity;
    }

    public void setGravity(boolean b) {
        this.gravity = b;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public void setPortalCooldown(int i) {
        this.portalCooldown = i;
    }

    @NotNull
    public Set<String> getScoreboardTags() {
        return Collections.emptySet();
    }

    public boolean addScoreboardTag(@NotNull String s) {
        return false;
    }

    public boolean removeScoreboardTag(@NotNull String s) {
        return false;
    }

    @NotNull
    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.MOVE;
    }

    @NotNull
    public BlockFace getFacing() {
        return BlockFace.DOWN;
    }

    @NotNull
    public Pose getPose() {
        return Pose.STANDING;
    }

    @NotNull
    public SpawnCategory getSpawnCategory() {
        return SpawnCategory.MISC;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public void setSneaking(boolean b) {
        this.sneaking = b;
    }

    public boolean isSprinting() {
        return this.sprinting;
    }

    public void setSprinting(boolean b) {
        this.sprinting = b;
        if (b) {
            this.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.15);
        } else {
            this.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.1);
        }
    }

    public void saveData() {
    }

    public void loadData() {
    }

    public void setSleepingIgnored(boolean b) {
        this.sleepingIgnored = b;
    }

    public boolean isSleepingIgnored() {
        return this.sleepingIgnored;
    }

    public boolean isOnline() {
        return false;
    }

    public boolean isBanned() {
        return false;
    }

    public boolean isWhitelisted() {
        return this.getServer().getWhitelistedPlayers().contains(this);
    }

    public void setWhitelisted(boolean b) {
    }

    @Nullable
    public Player getPlayer() {
        return this.getServer().getPlayer(this.getUniqueId());
    }

    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public boolean hasPlayedBefore() {
        return false;
    }

    @Nullable
    public Location getBedSpawnLocation() {
        if (this.bedSpawnLocation == null) {
            return ((World)this.getServer().getWorlds().get(0)).getSpawnLocation();
        }
        return this.bedSpawnLocation.clone();
    }

    public void incrementStatistic(@NotNull Statistic statistic) throws IllegalArgumentException {
        this.statistics.compute(statistic, (stat, existing) -> existing == null ? 1 : existing + 1);
    }

    public void decrementStatistic(@NotNull Statistic statistic) throws IllegalArgumentException {
        this.statistics.compute(statistic, (stat, existing) -> existing == null ? -1 : existing - 1);
    }

    public void incrementStatistic(@NotNull Statistic statistic, int i) throws IllegalArgumentException {
        this.statistics.compute(statistic, (stat, existing) -> existing == null ? i : existing + i);
    }

    public void decrementStatistic(@NotNull Statistic statistic, int i) throws IllegalArgumentException {
        this.statistics.compute(statistic, (stat, existing) -> existing == null ? -i : existing - i);
    }

    public void setStatistic(@NotNull Statistic statistic, int i) throws IllegalArgumentException {
        this.statistics.put(statistic, i);
    }

    public int getStatistic(@NotNull Statistic statistic) throws IllegalArgumentException {
        return this.statistics.getOrDefault(statistic, 0);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull Material material) throws IllegalArgumentException {
        this.incrementStatistic(statistic);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull Material material) throws IllegalArgumentException {
        this.decrementStatistic(statistic);
    }

    public int getStatistic(@NotNull Statistic statistic, @NotNull Material material) throws IllegalArgumentException {
        return this.getStatistic(statistic);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull Material material, int i) throws IllegalArgumentException {
        this.incrementStatistic(statistic, i);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull Material material, int i) throws IllegalArgumentException {
        this.decrementStatistic(statistic, i);
    }

    public void setStatistic(@NotNull Statistic statistic, @NotNull Material material, int i) throws IllegalArgumentException {
        this.setStatistic(statistic, i);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) throws IllegalArgumentException {
        this.incrementStatistic(statistic);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) throws IllegalArgumentException {
        this.decrementStatistic(statistic);
    }

    public int getStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) throws IllegalArgumentException {
        return this.getStatistic(statistic);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int i) throws IllegalArgumentException {
        this.incrementStatistic(statistic, i);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int i) {
        this.decrementStatistic(statistic, i);
    }

    public void setStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int i) {
        this.setStatistic(statistic, i);
    }

    public void setBedSpawnLocation(@Nullable Location location) {
        this.bedSpawnLocation = location == null ? null : location.clone();
    }

    public void setBedSpawnLocation(@Nullable Location location, boolean b) {
        this.setBedSpawnLocation(location);
    }

    public void playNote(@NotNull Location location, byte b, byte b1) {
    }

    public void playNote(@NotNull Location location, @NotNull Instrument instrument, @NotNull Note note) {
    }

    public void playSound(@NotNull Location location, @NotNull Sound sound, float v, float v1) {
    }

    public void playSound(@NotNull Location location, @NotNull String s, float v, float v1) {
    }

    public void playSound(@NotNull Location location, @NotNull Sound sound, @NotNull SoundCategory soundCategory, float v, float v1) {
    }

    public void playSound(@NotNull Location location, @NotNull String s, @NotNull SoundCategory soundCategory, float v, float v1) {
    }

    public void playSound(@NotNull Entity entity, @NotNull Sound sound, float v, float v1) {
    }

    public void playSound(@NotNull Entity entity, @NotNull String s, float v, float v1) {
    }

    public void playSound(@NotNull Entity entity, @NotNull Sound sound, @NotNull SoundCategory soundCategory, float v, float v1) {
    }

    public void playSound(@NotNull Entity entity, @NotNull String s, @NotNull SoundCategory soundCategory, float v, float v1) {
    }

    public void stopSound(@NotNull Sound sound) {
    }

    public void stopSound(@NotNull String s) {
    }

    public void stopSound(@NotNull Sound sound, @Nullable SoundCategory soundCategory) {
    }

    public void stopSound(@NotNull String s, @Nullable SoundCategory soundCategory) {
    }

    public void stopSound(@NotNull SoundCategory soundCategory) {
    }

    public void stopAllSounds() {
    }

    public void playEffect(@NotNull Location location, @NotNull Effect effect, int i) {
        this.getWorld().playEffect(location, effect, i);
    }

    public <T> void playEffect(@NotNull Location location, @NotNull Effect effect, @Nullable T t) {
        this.getWorld().playEffect(location, effect, t);
    }

    public void sendBlockChange(@NotNull Location location, @NotNull Material material, byte b) {
    }

    public void sendBlockChange(@NotNull Location location, @NotNull BlockData blockData) {
    }

    public void sendBlockChanges(@NotNull Collection<BlockState> collection, boolean b) {
    }

    public void sendBlockDamage(Location location, float damage) {
    }

    public void sendBlockDamage(@NotNull Location location, float v, @NotNull Entity entity) {
    }

    public void sendBlockDamage(@NotNull Location location, float v, int i) {
    }

    public void sendEquipmentChange(@NotNull LivingEntity livingEntity, @NotNull EquipmentSlot equipmentSlot, @NotNull ItemStack itemStack) {
    }

    public void sendEquipmentChange(@NotNull LivingEntity livingEntity, @NotNull Map<EquipmentSlot, ItemStack> map) {
    }

    public boolean sendChunkChange(@NotNull Location location, int i, int i1, int i2, @NotNull byte[] bytes) {
        return false;
    }

    public void sendSignChange(@NotNull Location location, @Nullable String[] strings) throws IllegalArgumentException {
    }

    public void sendSignChange(@NotNull Location location, @Nullable String[] strings, @NotNull DyeColor dyeColor) throws IllegalArgumentException {
    }

    public void sendSignChange(@NotNull Location location, @Nullable String[] strings, @NotNull DyeColor dyeColor, boolean b) throws IllegalArgumentException {
    }

    public void sendMap(@NotNull MapView mapView) {
    }

    public void sendHurtAnimation(float v) {
    }

    public void addCustomChatCompletions(@NotNull Collection<String> collection) {
    }

    public void removeCustomChatCompletions(@NotNull Collection<String> collection) {
    }

    public void setCustomChatCompletions(@NotNull Collection<String> collection) {
    }

    public boolean breakBlock(Block block) {
        return block.breakNaturally(this.getItemInUse());
    }

    public void updateInventory() {
    }

    @Nullable
    public GameMode getPreviousGameMode() {
        return this.previousGameMode;
    }

    public void setPlayerTime(long l, boolean b) {
        this.playerTime = l;
    }

    public long getPlayerTime() {
        return this.playerTime;
    }

    public long getPlayerTimeOffset() {
        return 0L;
    }

    public boolean isPlayerTimeRelative() {
        return false;
    }

    public void resetPlayerTime() {
        this.playerTime = 0L;
    }

    public void setPlayerWeather(@NotNull WeatherType weatherType) {
        this.weatherType = weatherType;
    }

    @Nullable
    public WeatherType getPlayerWeather() {
        return this.weatherType;
    }

    public void resetPlayerWeather() {
        this.setPlayerWeather(WeatherType.CLEAR);
    }

    public int getExpCooldown() {
        return this.expCooldown;
    }

    public void setExpCooldown(int i) {
        this.expCooldown = i;
    }

    public void giveExp(int i) {
        this.setExp(this.getExp() + (float)i);
    }

    public void giveExpLevels(int i) {
        this.setLevel(this.getLevel() + i);
    }

    public float getExp() {
        return this.exp;
    }

    public void setExp(float v) {
        this.exp = v;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int i) {
        this.level = i;
    }

    public int getTotalExperience() {
        if (this.totalExperience != null) {
            return this.totalExperience;
        }
        int level = this.getLevel();
        if (0 <= level && level <= 16) {
            return (6 + level) * level;
        }
        if (17 <= level && level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level - 162.5 * (double)level + 2220.0);
    }

    public void setTotalExperience(int i) {
        this.totalExperience = i;
    }

    public void sendExperienceChange(float v) {
    }

    public void sendExperienceChange(float v, int i) {
    }

    public float getExhaustion() {
        return this.exhaustion;
    }

    public void setExhaustion(float v) {
        this.exhaustion = v;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float v) {
        this.saturation = v;
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public void setFoodLevel(int i) {
        this.foodLevel = i;
    }

    public boolean getAllowFlight() {
        return this.allowFlight;
    }

    public void setAllowFlight(boolean b) {
        this.allowFlight = b;
    }

    public void hidePlayer(@NotNull Player player) {
    }

    public void hidePlayer(@NotNull Plugin plugin, @NotNull Player player) {
    }

    public void showPlayer(@NotNull Player player) {
    }

    public void showPlayer(@NotNull Plugin plugin, @NotNull Player player) {
    }

    public boolean canSee(@NotNull Player player) {
        return true;
    }

    public void hideEntity(@NotNull Plugin plugin, @NotNull Entity entity) {
        this.hiddenEntities.computeIfAbsent(plugin, k -> new HashSet()).add(entity);
    }

    public void showEntity(@NotNull Plugin plugin, @NotNull Entity entity) {
        Set<Entity> hiddenEntities = this.hiddenEntities.get(plugin);
        if (hiddenEntities != null) {
            hiddenEntities.remove(entity);
        }
    }

    public boolean canSee(@NotNull Entity entity) {
        return this.hiddenEntities.values().stream().noneMatch(set -> set.contains(entity));
    }

    public boolean isFlying() {
        return this.flying;
    }

    public void setFlying(boolean b) {
        this.flying = b;
    }

    public void setFlySpeed(float v) throws IllegalArgumentException {
        this.flySpeed = v;
    }

    public void setWalkSpeed(float v) throws IllegalArgumentException {
        this.walkSpeed = v;
    }

    public float getFlySpeed() {
        return this.flySpeed;
    }

    public float getWalkSpeed() {
        return this.walkSpeed;
    }

    public void setTexturePack(@NotNull String s) {
    }

    public void setResourcePack(@NotNull String s) {
    }

    public void setResourcePack(@NotNull String s, @NotNull byte[] bytes) {
    }

    public void setResourcePack(@NotNull String s, @Nullable byte[] bytes, @Nullable String s1) {
    }

    public void setResourcePack(@NotNull String s, @Nullable byte[] bytes, boolean b) {
    }

    public void setResourcePack(@NotNull String s, @Nullable byte[] bytes, @Nullable String s1, boolean b) {
    }

    @NotNull
    public Scoreboard getScoreboard() {
        if (this.scoreboard == null) {
            return this.getServer().getScoreboardManager().getMainScoreboard();
        }
        return this.scoreboard;
    }

    public void setScoreboard(@NotNull Scoreboard scoreboard) throws IllegalArgumentException, IllegalStateException {
        this.scoreboard = scoreboard;
    }

    public boolean isHealthScaled() {
        return this.healthScaled;
    }

    public void setHealthScaled(boolean b) {
        this.healthScaled = b;
    }

    public void setHealthScale(double v) throws IllegalArgumentException {
        this.healthScale = v;
    }

    public double getHealthScale() {
        return this.healthScale;
    }

    public void setStarvationRate(int rate) {
        this.starvationRate = rate;
    }

    @Nullable
    public Location getLastDeathLocation() {
        return this.lastDeathLocation == null ? null : this.lastDeathLocation.clone();
    }

    public void setLastDeathLocation(@Nullable Location location) {
        this.lastDeathLocation = location == null ? null : location.clone();
    }

    @Nullable
    public Firework fireworkBoost(@NotNull ItemStack itemStack) {
        return null;
    }

    public int getStarvationRate() {
        return this.starvationRate;
    }

    public void setUnsaturatedRegenRate(int rate) {
        this.unsaturatedRegenerationRate = rate;
    }

    public int getUnsaturatedRegenRate() {
        return this.unsaturatedRegenerationRate;
    }

    public void setSaturatedRegenRate(int rate) {
        this.saturatedRegenerationRate = rate;
    }

    public int getSaturatedRegenRate() {
        return this.saturatedRegenerationRate;
    }

    @Nullable
    public Entity getSpectatorTarget() {
        return this.spectatorTarget;
    }

    public void setSpectatorTarget(@Nullable Entity entity) {
        this.spectatorTarget = entity;
    }

    public void sendTitle(@Nullable String s, @Nullable String s1) {
    }

    public void sendTitle(@Nullable String s, @Nullable String s1, int i, int i1, int i2) {
    }

    public void resetTitle() {
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int i) {
        this.getWorld().spawnParticle(particle, location, i);
    }

    public void spawnParticle(@NotNull Particle particle, double v, double v1, double v2, int i) {
        this.getWorld().spawnParticle(particle, v, v1, v2, i);
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int i, @Nullable T t) {
        this.getWorld().spawnParticle(particle, location, i, t);
    }

    public <T> void spawnParticle(@NotNull Particle particle, double v, double v1, double v2, int i, @Nullable T t) {
        this.getWorld().spawnParticle(particle, v, v1, v2, i, t);
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int i, double v, double v1, double v2) {
        this.getWorld().spawnParticle(particle, location, i, v, v1, v2);
    }

    public void spawnParticle(@NotNull Particle particle, double v, double v1, double v2, int i, double v3, double v4, double v5) {
        this.getWorld().spawnParticle(particle, v, v1, v2, i, v3, v4, v5);
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int i, double v, double v1, double v2, @Nullable T t) {
        this.getWorld().spawnParticle(particle, location, i, v, v1, v2, t);
    }

    public <T> void spawnParticle(@NotNull Particle particle, double v, double v1, double v2, int i, double v3, double v4, double v5, @Nullable T t) {
        this.getWorld().spawnParticle(particle, v, v1, v2, i, v3, v4, v5, t);
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int i, double v, double v1, double v2, double v3) {
        this.getWorld().spawnParticle(particle, location, i, v, v1, v2, v3);
    }

    public void spawnParticle(@NotNull Particle particle, double v, double v1, double v2, int i, double v3, double v4, double v5, double v6) {
        this.getWorld().spawnParticle(particle, v, v1, v2, i, v3, v4, v5, v6);
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int i, double v, double v1, double v2, double v3, @Nullable T t) {
        this.getWorld().spawnParticle(particle, location, i, v, v1, v2, v3, t);
    }

    public <T> void spawnParticle(@NotNull Particle particle, double v, double v1, double v2, int i, double v3, double v4, double v5, double v6, @Nullable T t) {
        this.getWorld().spawnParticle(particle, v, v1, v2, i, v3, v4, v5, v6, t);
    }

    @NotNull
    public AdvancementProgress getAdvancementProgress(@NotNull Advancement advancement) {
        return null;
    }

    public int getClientViewDistance() {
        return this.clientViewDistance;
    }

    @NotNull
    public String getLocale() {
        return Locale.ROOT.toString();
    }

    public void updateCommands() {
    }

    public void openBook(@NotNull ItemStack itemStack) {
    }

    public void openSign(@NotNull Sign sign) {
    }

    public void openSign(@NotNull Sign sign, @NotNull Side side) {
    }

    public void showDemoScreen() {
    }

    public boolean isAllowingServerListings() {
        return true;
    }

    @NotNull
    public Player.Spigot spigot() {
        return new Player.Spigot();
    }

    @NotNull
    public Map<String, Object> serialize() {
        return Collections.emptyMap();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public PlayerInventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public Inventory getEnderChest() {
        return this.enderChest;
    }

    @NotNull
    public MainHand getMainHand() {
        return this.mainHand;
    }

    public boolean setWindowProperty(@NotNull InventoryView.Property property, int i) {
        return false;
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed;
    }

    public void setEnchantmentSeed(int seed) {
        this.enchantmentSeed = seed;
    }

    @NotNull
    public InventoryView getOpenInventory() {
        return new InventoryView(){
            private String title = InventoryType.PLAYER.getDefaultTitle();

            @NotNull
            public Inventory getTopInventory() {
                return FakePlayer.this.getInventory();
            }

            @NotNull
            public Inventory getBottomInventory() {
                return FakePlayer.this.getInventory();
            }

            @NotNull
            public HumanEntity getPlayer() {
                return FakePlayer.this;
            }

            @NotNull
            public InventoryType getType() {
                return InventoryType.PLAYER;
            }

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getOriginalTitle() {
                return InventoryType.PLAYER.getDefaultTitle();
            }

            public void setTitle(@NotNull String s) {
                this.title = s;
            }
        };
    }

    @Nullable
    public InventoryView openInventory(@NotNull Inventory inventory) {
        return null;
    }

    @Nullable
    public InventoryView openWorkbench(@Nullable Location location, boolean b) {
        return null;
    }

    @Nullable
    public InventoryView openEnchanting(@Nullable Location location, boolean b) {
        return null;
    }

    public void openInventory(@NotNull InventoryView inventoryView) {
        this.openInventory(inventoryView.getTopInventory());
    }

    @Nullable
    public InventoryView openMerchant(@NotNull Villager villager, boolean b) {
        return null;
    }

    @Nullable
    public InventoryView openMerchant(@NotNull Merchant merchant, boolean b) {
        return null;
    }

    public void closeInventory() {
    }

    @NotNull
    public ItemStack getItemInHand() {
        return this.getInventory().getItemInMainHand();
    }

    public void setItemInHand(@Nullable ItemStack itemStack) {
        this.getInventory().setItemInMainHand(itemStack);
    }

    @NotNull
    public ItemStack getItemOnCursor() {
        return this.itemOnCursor;
    }

    public void setItemOnCursor(@Nullable ItemStack itemStack) {
        this.itemOnCursor = itemStack;
    }

    public boolean hasCooldown(@NotNull Material material) {
        return this.getCooldown(material) > 0;
    }

    public int getCooldown(@NotNull Material material) {
        return this.cooldowns.getOrDefault(material, 0);
    }

    public void setCooldown(@NotNull Material material, int i) {
        this.cooldowns.put(material, i);
    }

    public int getSleepTicks() {
        return 0;
    }

    public boolean sleep(@NotNull Location location, boolean b) {
        return false;
    }

    public void wakeup(boolean b) {
    }

    @NotNull
    public Location getBedLocation() {
        return this.getBedSpawnLocation();
    }

    @NotNull
    public GameMode getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(@NotNull GameMode gameMode) {
        this.previousGameMode = this.gameMode;
        this.gameMode = gameMode;
    }

    public boolean isBlocking() {
        return false;
    }

    public boolean isHandRaised() {
        return false;
    }

    @Nullable
    public ItemStack getItemInUse() {
        return null;
    }

    public int getExpToLevel() {
        int level = this.getLevel();
        if (0 <= level && level <= 15) {
            return 2 * level + 7;
        }
        if (16 <= level && level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    public float getAttackCooldown() {
        return 0.0f;
    }

    public boolean discoverRecipe(@NotNull NamespacedKey namespacedKey) {
        return this.getDiscoveredRecipes().add(namespacedKey);
    }

    public int discoverRecipes(@NotNull Collection<NamespacedKey> collection) {
        int result = 0;
        for (NamespacedKey key : collection) {
            if (!this.discoverRecipe(key)) continue;
            ++result;
        }
        return result;
    }

    public boolean undiscoverRecipe(@NotNull NamespacedKey namespacedKey) {
        return this.getDiscoveredRecipes().remove(namespacedKey);
    }

    public int undiscoverRecipes(@NotNull Collection<NamespacedKey> collection) {
        int result = 0;
        for (NamespacedKey key : collection) {
            if (!this.undiscoverRecipe(key)) continue;
            ++result;
        }
        return result;
    }

    public boolean hasDiscoveredRecipe(@NotNull NamespacedKey namespacedKey) {
        return this.getDiscoveredRecipes().contains(namespacedKey);
    }

    @NotNull
    public Set<NamespacedKey> getDiscoveredRecipes() {
        return this.discoveredRecipes;
    }

    @Nullable
    public Entity getShoulderEntityLeft() {
        return this.leftShoulder;
    }

    public void setShoulderEntityLeft(@Nullable Entity entity) {
        this.leftShoulder = entity;
    }

    @Nullable
    public Entity getShoulderEntityRight() {
        return this.rightShoulder;
    }

    public void setShoulderEntityRight(@Nullable Entity entity) {
        this.rightShoulder = entity;
    }

    public boolean dropItem(boolean b) {
        return false;
    }

    public double getEyeHeight() {
        if (this.isSneaking()) {
            return 1.3;
        }
        if (this.isSwimming() || this.isGliding()) {
            return 0.1;
        }
        return 1.5;
    }

    public double getEyeHeight(boolean b) {
        if (b) {
            return this.getEyeHeight();
        }
        return 1.5;
    }

    @NotNull
    public Location getEyeLocation() {
        return this.getLocation().add(0.0, this.getEyeHeight(), 0.0);
    }

    @NotNull
    public List<Block> getLineOfSight(@Nullable Set<Material> set, int i) {
        return Collections.emptyList();
    }

    @NotNull
    public Block getTargetBlock(@Nullable Set<Material> set, int i) {
        return this.getLocation().getBlock();
    }

    @NotNull
    public List<Block> getLastTwoTargetBlocks(@Nullable Set<Material> set, int i) {
        return Collections.emptyList();
    }

    @Nullable
    public Block getTargetBlockExact(int i) {
        return null;
    }

    @Nullable
    public Block getTargetBlockExact(int i, @NotNull FluidCollisionMode fluidCollisionMode) {
        return null;
    }

    @Nullable
    public RayTraceResult rayTraceBlocks(double v) {
        return null;
    }

    @Nullable
    public RayTraceResult rayTraceBlocks(double v, @NotNull FluidCollisionMode fluidCollisionMode) {
        return null;
    }

    public int getRemainingAir() {
        if (this.remainingAir == null) {
            return this.getMaximumAir();
        }
        return this.remainingAir;
    }

    public void setRemainingAir(int i) {
        this.remainingAir = i;
    }

    public int getMaximumAir() {
        if (this.maximumAir == null) {
            this.maximumAir = 20;
        }
        return this.maximumAir;
    }

    public void setMaximumAir(int i) {
        this.maximumAir = i;
    }

    public int getArrowCooldown() {
        return this.arrowCooldown;
    }

    public void setArrowCooldown(int ticks) {
        this.arrowCooldown = ticks;
    }

    public int getArrowsInBody() {
        return this.arrowsInBody;
    }

    public void setArrowsInBody(int count) {
        this.arrowsInBody = count;
    }

    public int getMaximumNoDamageTicks() {
        return this.maximumNoDamageTicks;
    }

    public void setMaximumNoDamageTicks(int i) {
        this.maximumNoDamageTicks = i;
    }

    public double getLastDamage() {
        if (this.lastDamage != null) {
            return this.lastDamage;
        }
        if (this.lastDamageCause != null) {
            return this.lastDamageCause.getDamage();
        }
        return 0.0;
    }

    public void setLastDamage(double v) {
        this.lastDamage = v;
    }

    public int getNoDamageTicks() {
        return this.noDamageTicks;
    }

    public void setNoDamageTicks(int i) {
        this.noDamageTicks = i;
    }

    @Nullable
    public Player getKiller() {
        return null;
    }

    public boolean addPotionEffect(@NotNull PotionEffect potionEffect) {
        PotionEffectType type = potionEffect.getType();
        PotionEffect old = this.potionEffects.get(type);
        if (old == null || old.getDuration() > potionEffect.getDuration() || potionEffect.getAmplifier() > old.getAmplifier()) {
            this.potionEffects.put(type, potionEffect);
            return true;
        }
        return false;
    }

    public boolean addPotionEffect(@NotNull PotionEffect potionEffect, boolean b) {
        return this.potionEffects.put(potionEffect.getType(), potionEffect) == null;
    }

    public boolean addPotionEffects(@NotNull Collection<PotionEffect> collection) {
        return collection.stream().anyMatch(this::addPotionEffect);
    }

    public boolean hasPotionEffect(@NotNull PotionEffectType potionEffectType) {
        return this.potionEffects.containsKey(potionEffectType);
    }

    @Nullable
    public PotionEffect getPotionEffect(@NotNull PotionEffectType potionEffectType) {
        return this.potionEffects.get(potionEffectType);
    }

    public void removePotionEffect(@NotNull PotionEffectType potionEffectType) {
        this.potionEffects.remove(potionEffectType);
    }

    @NotNull
    public Collection<PotionEffect> getActivePotionEffects() {
        return this.potionEffects.values();
    }

    public boolean hasLineOfSight(@NotNull Entity entity) {
        return false;
    }

    public boolean getRemoveWhenFarAway() {
        return this.removeWhenFarAway;
    }

    public void setRemoveWhenFarAway(boolean b) {
        this.removeWhenFarAway = b;
    }

    @Nullable
    public EntityEquipment getEquipment() {
        return this.inventory;
    }

    public void setCanPickupItems(boolean b) {
        this.canPickupItems = b;
    }

    public boolean getCanPickupItems() {
        return this.canPickupItems;
    }

    public boolean isLeashed() {
        return this.leashHolder != null;
    }

    @NotNull
    public Entity getLeashHolder() throws IllegalStateException {
        if (this.leashHolder == null) {
            return this;
        }
        return this.leashHolder;
    }

    public boolean setLeashHolder(@Nullable Entity entity) {
        boolean changed = Objects.equals(entity, this.leashHolder);
        this.leashHolder = entity;
        return changed;
    }

    public boolean isGliding() {
        return this.gliding;
    }

    public void setGliding(boolean b) {
        this.gliding = true;
    }

    public boolean isClimbing() {
        return false;
    }

    public boolean isSwimming() {
        return this.swimming;
    }

    public void setSwimming(boolean b) {
        this.swimming = true;
    }

    public boolean isRiptiding() {
        return false;
    }

    public boolean isSleeping() {
        return false;
    }

    public void setAI(boolean b) {
    }

    public boolean hasAI() {
        return false;
    }

    public void attack(@NotNull Entity entity) {
    }

    public void swingMainHand() {
    }

    public void swingOffHand() {
    }

    public void setCollidable(boolean b) {
        this.collidable = b;
    }

    public boolean isCollidable() {
        return this.collidable;
    }

    @NotNull
    public Set<UUID> getCollidableExemptions() {
        return Collections.emptySet();
    }

    @Nullable
    public <T> T getMemory(@NotNull MemoryKey<T> memoryKey) {
        return (T)this.memory.get(memoryKey);
    }

    public <T> void setMemory(@NotNull MemoryKey<T> memoryKey, @Nullable T t) {
        this.memory.put(memoryKey, t);
    }

    @Nullable
    public Sound getHurtSound() {
        return Sound.ENTITY_PLAYER_HURT;
    }

    @Nullable
    public Sound getDeathSound() {
        return Sound.ENTITY_PLAYER_DEATH;
    }

    @NotNull
    public Sound getFallDamageSound(int distance) {
        if (distance < 3) {
            return this.getFallDamageSoundSmall();
        }
        return this.getFallDamageSoundBig();
    }

    @NotNull
    public Sound getFallDamageSoundSmall() {
        return Sound.ENTITY_PLAYER_SMALL_FALL;
    }

    @NotNull
    public Sound getFallDamageSoundBig() {
        return Sound.ENTITY_PLAYER_BIG_FALL;
    }

    @NotNull
    public Sound getDrinkingSound(@NotNull ItemStack itemStack) {
        return Sound.ENTITY_GENERIC_DRINK;
    }

    @NotNull
    public Sound getEatingSound(@NotNull ItemStack itemStack) {
        return Sound.ENTITY_GENERIC_EAT;
    }

    public boolean canBreatheUnderwater() {
        return false;
    }

    @NotNull
    public EntityCategory getCategory() {
        return EntityCategory.NONE;
    }

    @Nullable
    public AttributeInstance getAttribute(@NotNull Attribute attribute) {
        return this.attributes.get(attribute);
    }

    public void damage(double v) {
        this.health -= v;
        this.lastDamageCause = new EntityDamageEvent((Entity)this, EntityDamageEvent.DamageCause.CUSTOM, v);
    }

    public void damage(double v, @Nullable Entity entity) {
        this.health -= v;
        this.lastDamageCause = new EntityDamageByEntityEvent(entity, (Entity)this, EntityDamageEvent.DamageCause.CUSTOM, v);
    }

    public double getHealth() {
        return this.health;
    }

    public void setHealth(double v) {
        this.health = v;
    }

    public double getAbsorptionAmount() {
        return this.absorptionAmount;
    }

    public void setAbsorptionAmount(double v) {
        this.absorptionAmount = v;
    }

    public double getMaxHealth() {
        return this.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
    }

    public void setMaxHealth(double v) {
        this.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(v);
        this.getAttribute(Attribute.GENERIC_MAX_HEALTH).getModifiers().clear();
    }

    public void resetMaxHealth() {
        this.setMaxHealth(20.0);
    }

    @Nullable
    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(@Nullable String s) {
        this.customName = s;
    }

    public void setMetadata(@NotNull String s, @NotNull MetadataValue metadataValue) {
        this.metadata.compute(s, (k, map) -> {
            if (map == null) {
                map = new HashMap<Plugin, MetadataValue>();
            }
            map.put(metadataValue.getOwningPlugin(), metadataValue);
            return map;
        });
    }

    @NotNull
    public List<MetadataValue> getMetadata(@NotNull String s) {
        return Compat.listCopy(this.metadata.getOrDefault(s, Collections.emptyMap()).values());
    }

    public boolean hasMetadata(@NotNull String s) {
        return this.metadata.containsKey(s);
    }

    public void removeMetadata(@NotNull String s, @NotNull Plugin plugin) {
        Map<Plugin, MetadataValue> v = this.metadata.get(s);
        if (v != null) {
            v.remove(plugin);
            if (v.isEmpty()) {
                this.metadata.remove(s);
            }
        }
    }

    public boolean isPermissionSet(@NotNull String s) {
        return this.permissible.isPermissionSet(s);
    }

    public boolean isPermissionSet(@NotNull Permission permission) {
        return this.permissible.isPermissionSet(permission);
    }

    public boolean hasPermission(@NotNull String s) {
        return this.permissible.hasPermission(s);
    }

    public boolean hasPermission(@NotNull Permission permission) {
        return this.permissible.hasPermission(permission);
    }

    @NotNull
    public PermissionAttachment addAttachment(@NotNull Plugin plugin, @NotNull String s, boolean b) {
        return this.permissible.addAttachment(plugin, s, b);
    }

    @NotNull
    public PermissionAttachment addAttachment(@NotNull Plugin plugin) {
        return this.permissible.addAttachment(plugin);
    }

    @Nullable
    public PermissionAttachment addAttachment(@NotNull Plugin plugin, @NotNull String s, boolean b, int i) {
        return this.permissible.addAttachment(plugin, s, b, i);
    }

    @Nullable
    public PermissionAttachment addAttachment(@NotNull Plugin plugin, int i) {
        return this.permissible.addAttachment(plugin, i);
    }

    public void removeAttachment(@NotNull PermissionAttachment permissionAttachment) {
        this.permissible.removeAttachment(permissionAttachment);
    }

    public void recalculatePermissions() {
        this.permissible.recalculatePermissions();
    }

    @NotNull
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.permissible.getEffectivePermissions();
    }

    public boolean isOp() {
        return this.operator;
    }

    public void setOp(boolean b) {
        this.operator = b;
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        if (this.persistentDataContainer == null) {
            this.persistentDataContainer = new FakePersistentDataContainer();
        }
        return this.persistentDataContainer;
    }

    public void sendPluginMessage(@NotNull Plugin plugin, @NotNull String s, @NotNull byte[] bytes) {
    }

    @NotNull
    public Set<String> getListeningPluginChannels() {
        return Collections.emptySet();
    }

    @NotNull
    public <T extends Projectile> T launchProjectile(@NotNull Class<? extends T> aClass) {
        Projectile entity = (Projectile)this.getWorld().spawnEntity(this.getLocation(), FakePlayer.projectileTypeFromClass(aClass));
        entity.setVelocity(this.getLocation().getDirection());
        return (T)entity;
    }

    @NotNull
    public <T extends Projectile> T launchProjectile(@NotNull Class<? extends T> aClass, @Nullable Vector vector) {
        Projectile entity = (Projectile)this.getWorld().spawnEntity(this.getLocation(), FakePlayer.projectileTypeFromClass(aClass));
        entity.setVelocity(vector);
        return (T)entity;
    }

    private static <P extends Projectile> EntityType projectileTypeFromClass(Class<? extends P> clazz) {
        if (Arrow.class.isAssignableFrom(clazz)) {
            return EntityType.ARROW;
        }
        if (SpectralArrow.class.isAssignableFrom(clazz)) {
            return EntityType.SPECTRAL_ARROW;
        }
        if (ThrownPotion.class.isAssignableFrom(clazz)) {
            return EntityType.SPLASH_POTION;
        }
        if (ThrownExpBottle.class.isAssignableFrom(clazz)) {
            return EntityType.THROWN_EXP_BOTTLE;
        }
        if (Snowball.class.isAssignableFrom(clazz)) {
            return EntityType.SNOWBALL;
        }
        if (DragonFireball.class.isAssignableFrom(clazz)) {
            return EntityType.DRAGON_FIREBALL;
        }
        if (Egg.class.isAssignableFrom(clazz)) {
            return EntityType.EGG;
        }
        if (EnderPearl.class.isAssignableFrom(clazz)) {
            return EntityType.ENDER_PEARL;
        }
        if (Fireball.class.isAssignableFrom(clazz)) {
            return EntityType.FIREBALL;
        }
        if (Firework.class.isAssignableFrom(clazz)) {
            return EntityType.FIREWORK;
        }
        if (FishHook.class.isAssignableFrom(clazz)) {
            return EntityType.FISHING_HOOK;
        }
        if (LlamaSpit.class.isAssignableFrom(clazz)) {
            return EntityType.LLAMA_SPIT;
        }
        if (ShulkerBullet.class.isAssignableFrom(clazz)) {
            return EntityType.SHULKER_BULLET;
        }
        if (Trident.class.isAssignableFrom(clazz)) {
            return EntityType.TRIDENT;
        }
        if (WitherSkull.class.isAssignableFrom(clazz)) {
            return EntityType.WITHER_SKULL;
        }
        return EntityType.UNKNOWN;
    }

    public void setWorldBorder(WorldBorder worldBorder) {
        this.worldBorder = worldBorder;
    }

    public WorldBorder getWorldBorder() {
        if (this.worldBorder == null) {
            this.worldBorder = this.getWorld().getWorldBorder();
        }
        return this.worldBorder;
    }
}

