/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.perworldinventory;

import com.janboerman.invsee.spigot.perworldinventory.PerWorldInventoryHook;
import com.janboerman.invsee.utils.Compat;
import com.janboerman.invsee.utils.Either;
import com.janboerman.invsee.utils.Out;
import com.janboerman.invsee.utils.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.ebonjaeger.perworldinventory.Group;
import org.bukkit.GameMode;
import org.bukkit.generator.WorldInfo;

public class PwiCommandArgs {
    private static final String formError = "Expected the following from: PWI{<property>=<value>,...} where <property> is one of [group, world, gamemode].";
    String world;
    Group group;
    GameMode gameMode;

    private PwiCommandArgs() {
    }

    public static Either<String, PwiCommandArgs> parse(String argument, PerWorldInventoryHook hook) {
        PwiCommandArgs result = new PwiCommandArgs();
        if (argument.isEmpty()) {
            return Either.left(formError);
        }
        if (!StringHelper.startsWithIgnoreCase(argument, "PWI")) {
            return Either.left(formError);
        }
        if (!StringHelper.startsWithIgnoreCase(argument, "PWI{") || !argument.endsWith("}")) {
            return Either.left(formError);
        }
        Optional<String> maybeError = PwiCommandArgs.parseProperties(result, argument = argument.substring(4, argument.length() - 1), hook);
        if (maybeError.isPresent()) {
            return Either.left(maybeError.get());
        }
        return Either.right(result);
    }

    private static Optional<String> parseProperties(@Out PwiCommandArgs result, String propertyList, PerWorldInventoryHook hook) {
        String[] properties;
        for (String kv : properties = propertyList.split(",")) {
            String[] keyValue = kv.split("=", 2);
            if (keyValue.length != 2) {
                return Optional.of("Invalid argument, expected <property>=<value>, but got " + kv + " instead.");
            }
            String key = keyValue[0];
            String value = keyValue[1];
            if ("world".equalsIgnoreCase(key)) {
                result.world = value;
                continue;
            }
            if ("group".equalsIgnoreCase(key)) {
                result.group = hook.getGroupByName(value);
                if (result.group != null) continue;
                return Optional.of("Invalid group: " + value + ", pick one of: " + hook.getGroupManager().getGroups().keySet());
            }
            if ("gamemode".equalsIgnoreCase(key)) {
                try {
                    result.gameMode = GameMode.valueOf((String)value.toUpperCase(Locale.ROOT));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    return Optional.of("Invalid gamemode: " + value + ", pick one of: " + Arrays.stream(GameMode.values()).map(gm -> gm.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(" ,", "[", "]")));
                }
            }
            return Optional.of("Invalid property, expected one of [group, world, gamemode] but got " + key + " instead.");
        }
        return Optional.empty();
    }

    public static List<String> complete(String argument, PerWorldInventoryHook hook) {
        if (argument.length() < 4) {
            return Compat.listOf("PWI{");
        }
        if (!StringHelper.startsWithIgnoreCase(argument, "PWI{")) {
            return Compat.listOf("PWI{group=", "PWI{world=", "PWI{gamemode=");
        }
        String propertyList = argument.substring(4);
        if (propertyList.endsWith("}")) {
            return Compat.listOf(argument);
        }
        Set groupNames = hook.getGroupManager().getGroups().keySet();
        Collection worldNames = hook.plugin.getServer().getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
        Collection gameModes = Arrays.stream(GameMode.values()).map(gm -> gm.name().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
        String[] properties = propertyList.split(",");
        if (properties.length == 0 || properties.length == 1 && properties[0].isEmpty()) {
            ArrayList<String> ret = new ArrayList<String>(9);
            for (String groupName2 : groupNames) {
                ret.add("PWI{group=" + groupName2 + "}");
            }
            for (String worldName2 : worldNames) {
                ret.add("PWI{world=" + worldName2 + "}");
            }
            for (String gameMode2 : gameModes) {
                ret.add("PWI{gamemode=" + gameMode2 + "}");
            }
            return ret;
        }
        PwiCommandArgs result = new PwiCommandArgs();
        PwiCommandArgs.parseProperties(result, propertyList, hook);
        String lastProperty = properties[properties.length - 1];
        int stripLength = lastProperty.length();
        boolean endsWithComma = argument.endsWith(",");
        if (endsWithComma) {
            ++stripLength;
        }
        String bufferBeforeLastProperty = argument.substring(0, argument.length() - stripLength);
        if (endsWithComma) {
            ArrayList<String> everything = new ArrayList<String>(9);
            if (result.group == null) {
                groupNames.stream().map(gn -> argument + "group=" + gn).forEach(everything::add);
            } else if (result.world == null) {
                worldNames.stream().map(wn -> argument + "world=" + wn).forEach(everything::add);
            } else if (result.gameMode == null) {
                gameModes.stream().map(gm -> argument + "gamemode=" + gm).forEach(everything::add);
            } else {
                return Compat.listOf(argument.substring(argument.length() - 1) + "}");
            }
            return everything;
        }
        String[] propKeyValue = lastProperty.split("=", 2);
        if (propKeyValue.length == 0 || propKeyValue.length == 1 && propKeyValue[0].isEmpty()) {
            if (result.group == null) {
                return groupNames.stream().map(groupName -> bufferBeforeLastProperty + "group=" + groupName).flatMap(buf -> Stream.of(buf + "}", buf + ",")).collect(Collectors.toList());
            }
            if (result.world == null) {
                return worldNames.stream().map(worldName -> bufferBeforeLastProperty + "world=" + worldName).flatMap(buf -> Stream.of(buf + "}", buf + ",")).collect(Collectors.toList());
            }
            if (result.gameMode == null) {
                return gameModes.stream().map(gameMode -> bufferBeforeLastProperty + "gamemode=" + gameMode).flatMap(buf -> Stream.of(buf + "}", buf + ",")).collect(Collectors.toList());
            }
            return Compat.listOf(argument + "}");
        }
        String key = propKeyValue[0];
        if (propKeyValue.length == 1) {
            if (StringHelper.startsWithIgnoreCase("group", key)) {
                return Compat.listOf(bufferBeforeLastProperty + "group=");
            }
            if (StringHelper.startsWithIgnoreCase("world", key)) {
                return Compat.listOf(bufferBeforeLastProperty + "world=");
            }
            if (StringHelper.startsWithIgnoreCase("gamemode", key)) {
                return Compat.listOf(bufferBeforeLastProperty + "gamemode=");
            }
            return Compat.listOf(bufferBeforeLastProperty + "group=", bufferBeforeLastProperty + "world=", bufferBeforeLastProperty + "gamemode=");
        }
        String value = propKeyValue[1];
        switch (key.toLowerCase(Locale.ROOT)) {
            case "group": {
                Set matchingGroups = (Set)((Object)groupNames.stream().filter(gn -> StringHelper.startsWithIgnoreCase(gn, value)).collect(Collectors.toList()));
                if (matchingGroups.isEmpty()) {
                    matchingGroups = groupNames;
                }
                return matchingGroups.stream().map(gn -> bufferBeforeLastProperty + "group=" + gn).flatMap(buf -> Stream.of(buf + "}", buf + ",")).collect(Collectors.toList());
            }
            case "world": {
                Collection matchingWorlds = worldNames.stream().filter(wn -> StringHelper.startsWithIgnoreCase(wn, value)).collect(Collectors.toList());
                if (matchingWorlds.isEmpty()) {
                    matchingWorlds = worldNames;
                }
                return matchingWorlds.stream().map(wn -> bufferBeforeLastProperty + "world=" + wn).flatMap(buf -> Stream.of(buf + "}", buf + ",")).collect(Collectors.toList());
            }
            case "gamemode": {
                Collection matchingGameModes = gameModes.stream().filter(gm -> StringHelper.startsWithIgnoreCase(gm, value)).collect(Collectors.toList());
                if (matchingGameModes.isEmpty()) {
                    matchingGameModes = gameModes;
                }
                return matchingGameModes.stream().map(gm -> bufferBeforeLastProperty + "gamemode=" + gm).flatMap(buf -> Stream.of(buf + "}", buf + ",")).collect(Collectors.toList());
            }
        }
        ArrayList everything = new ArrayList(9);
        if (result.group == null) {
            everything.addAll(groupNames.stream().map(gn -> "group=" + gn).collect(Collectors.toList()));
        }
        if (result.world == null) {
            everything.addAll(worldNames.stream().map(wn -> "world=" + wn).collect(Collectors.toList()));
        }
        if (result.gameMode == null) {
            everything.addAll(gameModes.stream().map(gm -> "gamemode=" + gm).collect(Collectors.toList()));
        }
        Stream<String> stream = everything.stream().map(property -> bufferBeforeLastProperty + property);
        stream = result.group != null && result.world != null && result.gameMode != null ? stream.map(buf -> buf + "}") : stream.flatMap(buf -> Stream.of(buf + "}", buf + ","));
        return stream.collect(Collectors.toList());
    }
}

