/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.utils;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class ConcatList<T>
extends AbstractList<T> {
    private final List<T> first;
    private final List<T> second;

    public ConcatList(List<T> first, List<T> second) {
        this.first = Objects.requireNonNull(first);
        this.second = Objects.requireNonNull(second);
    }

    @Override
    public T get(int index) {
        int firstSize = this.first.size();
        if (index < firstSize) {
            return this.first.get(index);
        }
        return this.second.get(index - firstSize);
    }

    @Override
    public int size() {
        return this.first.size() + this.second.size();
    }

    @Override
    public T set(int index, T element) {
        int firstSize = this.first.size();
        if (index < firstSize) {
            return this.first.set(index, element);
        }
        return this.second.set(index - firstSize, element);
    }

    @Override
    public int indexOf(Object o) {
        int index = this.first.indexOf(o);
        if (index != -1) {
            return index;
        }
        index = this.second.indexOf(o);
        if (index != -1) {
            index += this.first.size();
        }
        return index;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = this.second.lastIndexOf(o);
        if (index != -1) {
            return index + this.first.size();
        }
        return this.first.lastIndexOf(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(final int index) {
        return new ListIterator<T>(){
            boolean isFirst;
            ListIterator<T> running;
            final /* synthetic */ ConcatList this$0;
            {
                this.this$0 = this$0;
                this.isFirst = index < this.this$0.first.size();
                this.running = this.isFirst ? this.this$0.first.listIterator(index) : this.this$0.second.listIterator(index - this.this$0.first.size());
            }

            @Override
            public boolean hasNext() {
                if (this.isFirst) {
                    return this.running.hasNext() || !this.this$0.second.isEmpty();
                }
                return this.running.hasNext();
            }

            @Override
            public T next() {
                Object next;
                if (this.isFirst && this.running.hasNext()) {
                    next = this.running.next();
                } else {
                    this.isFirst = false;
                    this.running = this.this$0.second.listIterator(0);
                    next = this.running.next();
                }
                return next;
            }

            @Override
            public boolean hasPrevious() {
                if (this.isFirst) {
                    return this.running.hasPrevious();
                }
                return this.running.hasPrevious() || !this.this$0.first.isEmpty();
            }

            @Override
            public T previous() {
                Object previous;
                if (!this.isFirst && this.running.hasPrevious()) {
                    previous = this.running.previous();
                } else {
                    this.isFirst = true;
                    this.running = this.this$0.first.listIterator(this.this$0.first.size());
                    previous = this.running.previous();
                }
                return previous;
            }

            @Override
            public int nextIndex() {
                if (this.isFirst) {
                    return this.running.nextIndex();
                }
                return this.running.nextIndex() + this.this$0.first.size();
            }

            @Override
            public int previousIndex() {
                if (this.isFirst) {
                    return this.running.previousIndex();
                }
                return this.running.previousIndex() + this.this$0.first.size();
            }

            @Override
            public void remove() {
                this.running.remove();
            }

            @Override
            public void set(T t) {
                this.running.set(t);
            }

            @Override
            public void add(T t) {
                this.running.add(t);
            }
        };
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex >= toIndex) {
            throw new IllegalArgumentException("fromIndex (" + fromIndex + ") must be strictly smaller than toIndex (" + toIndex + ")");
        }
        if (fromIndex == 0 && toIndex == this.first.size()) {
            return this.first;
        }
        if (fromIndex == this.first.size() && toIndex == this.size()) {
            return this.second;
        }
        if (toIndex < this.first.size()) {
            return this.first.subList(fromIndex, toIndex);
        }
        if (fromIndex >= this.first.size()) {
            return this.second.subList(fromIndex - this.first.size(), toIndex - this.first.size());
        }
        return super.subList(fromIndex, toIndex);
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.first.contains(o) || this.second.contains(o);
    }

    @Override
    public Object[] toArray() {
        Object[] firstArray = this.first.toArray();
        Object[] secondArray = this.second.toArray();
        Object[] dest = new Object[firstArray.length + secondArray.length];
        System.arraycopy(firstArray, 0, dest, 0, firstArray.length);
        System.arraycopy(secondArray, 0, dest, firstArray.length, secondArray.length);
        return dest;
    }

    @Override
    public <E> E[] toArray(E[] array) {
        int size = this.size();
        Class<?> componentType = array.getClass().getComponentType();
        E[] r = array.length >= size ? array : (Object[])Array.newInstance(componentType, size);
        E[] resultArray = this.first.toArray(r);
        Object[] secondPart = this.second.toArray((Object[])Array.newInstance(componentType, 0));
        System.arraycopy(secondPart, 0, resultArray, this.first.size(), this.second.size());
        return resultArray;
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        this.first.replaceAll(operator);
        this.second.replaceAll(operator);
    }

    @Override
    public Spliterator<T> spliterator() {
        return new Spliterator<T>(){
            private boolean isFirst = true;
            private Spliterator<T> running = ConcatList.access$000(ConcatList.this).spliterator();

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                boolean advanced = this.running.tryAdvance(consumer);
                if (!advanced && this.isFirst) {
                    this.isFirst = false;
                    this.running = ConcatList.this.second.spliterator();
                    advanced = this.running.tryAdvance(consumer);
                }
                return advanced;
            }

            @Override
            public Spliterator<T> trySplit() {
                return this.running.trySplit();
            }

            @Override
            public long estimateSize() {
                return (long)ConcatList.this.first.size() + (long)ConcatList.this.second.size();
            }

            @Override
            public int characteristics() {
                return 16464;
            }
        };
    }

    @Override
    public Stream<T> stream() {
        return Stream.concat(this.first.stream(), this.second.stream());
    }

    @Override
    public Stream<T> parallelStream() {
        return Stream.concat(this.first.parallelStream(), this.second.parallelStream());
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.first.forEach(action);
        this.second.forEach(action);
    }

    @Override
    public boolean add(T t) {
        return this.second.add(t);
    }

    @Override
    public void add(int index, T element) {
        int firstSize = this.first.size();
        if (index <= firstSize) {
            this.first.add(index, element);
        } else {
            this.second.add(index - firstSize, element);
        }
    }

    @Override
    public T remove(int index) {
        int firstSize = this.first.size();
        if (index <= firstSize) {
            return this.first.remove(index);
        }
        return this.second.remove(index - firstSize);
    }

    @Override
    public void clear() {
        this.first.clear();
        this.second.clear();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int firstSize = this.first.size();
        if (index <= firstSize) {
            return this.first.addAll(index, c);
        }
        return this.second.addAll(index - firstSize, c);
    }

    @Override
    public boolean remove(Object o) {
        return this.first.remove(o) || this.second.remove(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.second.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.first.removeAll(c) | this.second.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.first.retainAll(c) | this.second.retainAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.first.removeIf(filter) | this.second.removeIf(filter);
    }
}

