/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.utils;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;

public abstract class Either<L, R> {
    private Either() {
    }

    public static <L, R> Either<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    public abstract boolean isLeft();

    public abstract boolean isRight();

    public abstract L getLeft();

    public abstract R getRight();

    public abstract <R2> Either<L, R2> castRight();

    public abstract <L2> Either<L2, R> castLeft();

    public <R2> Either<L, R2> flatMap(Function<? super R, ? extends Either<L, R2>> f) {
        if (this.isLeft()) {
            return this.castRight();
        }
        assert (this.isRight());
        return f.apply(this.getRight());
    }

    public <L2> Either<L2, R> tryRecover(Function<? super L, ? extends Either<L2, R>> f) {
        if (this.isLeft()) {
            return f.apply(this.getLeft());
        }
        assert (this.isRight());
        return this.castLeft();
    }

    public <R2> Either<L, R2> mapRight(Function<? super R, ? extends R2> f) {
        if (this.isLeft()) {
            return this.castRight();
        }
        assert (this.isRight());
        return Either.right(f.apply(this.getRight()));
    }

    public <L2> Either<L2, R> mapLeft(Function<? super L, ? extends L2> f) {
        if (this.isLeft()) {
            return Either.left(f.apply(this.getLeft()));
        }
        assert (this.isRight());
        return this.castLeft();
    }

    private static final class Left<L, R>
    extends Either<L, R> {
        private final L value;

        private Left(L value) {
            this.value = value;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public L getLeft() {
            return this.value;
        }

        @Override
        public R getRight() {
            throw new NoSuchElementException("left");
        }

        @Override
        public <R2> Either<L, R2> castRight() {
            return this;
        }

        @Override
        public <L2> Either<L2, R> castLeft() {
            throw new IllegalStateException("left");
        }

        public String toString() {
            return "Left[" + this.value + ']';
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Left)) {
                return false;
            }
            Left that = (Left)o;
            return Objects.equals(this.value, that.value);
        }
    }

    private static final class Right<L, R>
    extends Either<L, R> {
        private final R value;

        private Right(R value) {
            this.value = value;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public L getLeft() {
            throw new NoSuchElementException("right");
        }

        @Override
        public R getRight() {
            return this.value;
        }

        @Override
        public <R2> Either<L, R2> castRight() {
            throw new IllegalStateException("right");
        }

        @Override
        public <L2> Either<L2, R> castLeft() {
            return this;
        }

        public String toString() {
            return "Right[" + this.value + ']';
        }

        public int hashCode() {
            return Objects.hashCode(this.value) + 1;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Right)) {
                return false;
            }
            Right that = (Right)o;
            return Objects.equals(this.value, that.value);
        }
    }
}

