/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.utils;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface Ref<T> {
    public void set(T var1);

    public T get();

    public static <T> Ref<T> empty(final T empty) {
        return new Ref<T>(){

            @Override
            public T get() {
                return empty;
            }

            @Override
            public void set(T item) {
            }
        };
    }

    public static <T> Ref<T> of(final Supplier<? extends T> get, final Consumer<? super T> set) {
        return new Ref<T>(){

            @Override
            public T get() {
                return get.get();
            }

            @Override
            public void set(T item) {
                set.accept(item);
            }
        };
    }

    public static <T> Ref<T> ofArray(final int index, final T[] array) {
        return new Ref<T>(){

            @Override
            public T get() {
                return array[index];
            }

            @Override
            public void set(T item) {
                array[index] = item;
            }
        };
    }

    public static <T> Ref<T> ofList(final int index, final List<T> list) {
        return new Ref<T>(){

            @Override
            public T get() {
                return list.get(index);
            }

            @Override
            public void set(T item) {
                list.set(index, item);
            }
        };
    }

    public static <K, V> Ref<V> ofMap(final K key, final Map<K, V> map) {
        return new Ref<V>(){

            @Override
            public V get() {
                return map.get(key);
            }

            @Override
            public void set(V value) {
                map.put(key, value);
            }
        };
    }
}

