/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.utils;

import com.janboerman.invsee.utils.Ref;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;

public class SingletonList<T>
implements List<T>,
RandomAccess {
    private final Ref<T> ref;

    public SingletonList(Ref<T> ref) {
        this.ref = Objects.requireNonNull(ref);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return Objects.equals(this.ref.get(), o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.ref.get()};
    }

    @Override
    public <R> R[] toArray(R[] a2) {
        Objects.requireNonNull(a2);
        if (a2.length == 0) {
            a2 = new Object[]{this.ref.get()};
        }
        return a2;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("cannot add items to a SingletonList");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("cannot remove items from a SingletonList");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(item -> Objects.equals(this.ref.get(), item));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("cannot add items to a SingletonList");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("cannot add items to a SingletonList");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("cannot remove items from a SingletonList");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("cannot remove items from a SingletonList");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("cannot clear singleton list");
    }

    @Override
    public T get(int index) {
        if (index != 0) {
            throw new IllegalArgumentException(new IndexOutOfBoundsException("Index out of range: " + index));
        }
        return this.ref.get();
    }

    @Override
    public T set(int index, T element) {
        if (index != 0) {
            throw new IllegalArgumentException(new IndexOutOfBoundsException("Index out of range: " + index));
        }
        T old = this.ref.get();
        this.ref.set(element);
        return old;
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("cannot add items to a SingletonList");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("cannot remove items from a SingletonList");
    }

    @Override
    public int indexOf(Object o) {
        if (this.contains(o)) {
            return 0;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(final int index) {
        return new ListIterator<T>(){
            int cursor;
            final /* synthetic */ SingletonList this$0;
            {
                this.this$0 = this$0;
                this.cursor = index;
            }

            @Override
            public boolean hasNext() {
                return this.cursor == 0;
            }

            @Override
            public T next() {
                if (this.cursor == 0) {
                    this.cursor = 1;
                    return this.this$0.ref.get();
                }
                throw new NoSuchElementException("SingletonList iterator is already done");
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor == 1;
            }

            @Override
            public T previous() {
                if (this.cursor == 1) {
                    this.cursor = 0;
                    return this.this$0.ref.get();
                }
                throw new NoSuchElementException("SingletonList iterator is already done");
            }

            @Override
            public int nextIndex() {
                return 0;
            }

            @Override
            public int previousIndex() {
                return 0;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("cannot remove items from a SingletonList");
            }

            @Override
            public void set(T t) {
                if (this.cursor == 0) {
                    this.this$0.ref.set(t);
                }
            }

            @Override
            public void add(T t) {
                throw new UnsupportedOperationException("cannot add items to a SingletonList");
            }
        };
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex != 0 && fromIndex != 1) {
            throw new IllegalArgumentException("fromIndex must be 0 or 1", new IndexOutOfBoundsException("Index out of range: " + fromIndex));
        }
        if (toIndex != 0 && toIndex != 1) {
            throw new IllegalArgumentException("toIndex must be 0 or 1", new IndexOutOfBoundsException("Index out of range: " + toIndex));
        }
        if (toIndex == 0 || fromIndex == toIndex) {
            return Collections.emptyList();
        }
        return this;
    }
}

