/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.utils;

import com.janboerman.invsee.utils.ArrayHelper;
import com.janboerman.invsee.utils.Maybe;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;

public class UsernameTrie<V> {
    private final Node<V> root;

    public UsernameTrie(V rootValue) {
        this.root = new Node(new char[0], (Maybe)Maybe.just(rootValue), null);
    }

    public UsernameTrie() {
        this.root = new Node(new char[0], Maybe.nothing(), null);
    }

    public Maybe<V> insert(String username, V value) {
        return this.insert(username.toCharArray(), value);
    }

    public synchronized Maybe<V> insert(char[] username, V value) {
        Node node = ((Node)this.root).lookup(username);
        Maybe oldValue = node.value;
        node.value = Maybe.just(value);
        return oldValue;
    }

    public Maybe<V> delete(String username) {
        return this.delete(username.toCharArray());
    }

    public synchronized Maybe<V> delete(char[] username) {
        Node node = ((Node)this.root).lookup(username);
        Maybe oldValue = node.value;
        node.value = Maybe.nothing();
        node.cleanUp();
        return oldValue;
    }

    public Maybe<V> get(String username) {
        return this.get(username.toCharArray());
    }

    public synchronized Maybe<V> get(char[] username) {
        Node node = ((Node)this.root).lookup(username);
        Maybe value = node.value;
        node.cleanUp();
        return value;
    }

    public void traverse(String prefix, BiConsumer<String, ? super V> consumer) {
        this.traverse(prefix.toCharArray(), (char[] chars, ? super V v) -> consumer.accept(new String((char[])chars), (Object)v));
    }

    public synchronized void traverse(char[] prefix, BiConsumer<char[], ? super V> consumer) {
        Node node = ((Node)this.root).lookup(prefix);
        node.traverse(consumer);
        node.cleanUp();
    }

    private static class Node<V> {
        private static final Comparator<Character> CHAR_COMPARATOR = (character1, character2) -> {
            char c1 = character1.charValue();
            char c2 = character2.charValue();
            if (Character.isLetter(c1) && Character.isLetter(c2)) {
                char l2;
                char l1 = Character.toLowerCase(c1);
                if (l1 == (l2 = Character.toLowerCase(c2))) {
                    return Character.compare(c1, c2);
                }
                return Character.compare(l1, l2);
            }
            if (Character.isLetter(c1)) {
                return 1;
            }
            if (Character.isLetter(c2)) {
                return -1;
            }
            return Character.compare(c1, c2);
        };
        private final char[] segment;
        private Maybe<V> value;
        private TreeMap<Character, Node<V>> children;
        private Node<V> parent;

        private Node(char[] segment, Maybe<V> value, Node<V> parent) {
            this(segment, value, null, parent);
        }

        private Node(char[] segment, Maybe<V> value, TreeMap<Character, Node<V>> children, Node<V> parent) {
            assert (segment != null) : "segment cannot be null";
            assert (value != null) : "value cannot be null";
            this.segment = segment;
            this.value = value;
            this.children = children;
            this.parent = parent;
        }

        private boolean isEmpty() {
            if (this.value.isPresent()) {
                return false;
            }
            if (this.children == null) {
                return true;
            }
            for (Node<V> child : this.children.values()) {
                if (child == null || super.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private void cleanUp() {
            if (this.parent != null) {
                if (this.isEmpty()) {
                    this.parent.children.remove(Character.valueOf(this.segment[0]));
                    super.cleanUp();
                } else if (!this.value.isPresent()) {
                    for (Character sibling : this.parent.children.keySet()) {
                        if (sibling.equals(Character.valueOf(this.segment[0]))) continue;
                        return;
                    }
                    if (this.children == null || this.children.isEmpty()) {
                        return;
                    }
                    if (this.children.size() > 1) {
                        return;
                    }
                    Map.Entry<Character, Node<V>> entry = this.children.firstEntry();
                    Node<V> theNode = entry.getValue();
                    char[] newSegment = ArrayHelper.concat(this.segment, theNode.segment);
                    Node<V> longNode = new Node<V>(newSegment, theNode.value, theNode.children, this.parent);
                    this.parent.children.put(Character.valueOf(newSegment[0]), longNode);
                    super.cleanUp();
                }
            }
        }

        private void ensureChildrenNotNull() {
            if (this.children == null) {
                this.children = new TreeMap(CHAR_COMPARATOR);
            }
        }

        private Node<V> lookup(char[] segment) {
            int i;
            assert (segment != null) : "lookup segment cannot be null";
            if (segment.length == 0) {
                return this;
            }
            this.ensureChildrenNotNull();
            char childKey = segment[0];
            Node<Object> child = this.children.get(Character.valueOf(childKey));
            if (child == null) {
                child = new Node(segment, Maybe.nothing(), this);
                this.children.put(Character.valueOf(childKey), child);
                return child;
            }
            char[] childSegment = child.segment;
            for (i = 0; i < childSegment.length && i < segment.length && childSegment[i] == segment[i]; ++i) {
            }
            if (i == Math.min(childSegment.length, segment.length)) {
                if (childSegment.length == segment.length) {
                    return child;
                }
                if (childSegment.length < segment.length) {
                    char[] suffix = Arrays.copyOfRange(segment, childSegment.length, segment.length);
                    return super.lookup(suffix);
                }
                assert (childSegment.length > segment.length);
                char[] suffix = Arrays.copyOfRange(childSegment, segment.length, childSegment.length);
                Node replacingChild = new Node(segment, Maybe.nothing(), this);
                Node<V> grandChild = new Node<V>(suffix, child.value, child.children, replacingChild);
                super.ensureChildrenNotNull();
                replacingChild.children.put(Character.valueOf(suffix[0]), grandChild);
                this.children.put(Character.valueOf(childKey), replacingChild);
                return replacingChild;
            }
            char[] commonPrefix = Arrays.copyOfRange(childSegment, 0, i);
            char[] suffixChildSegment = Arrays.copyOfRange(childSegment, i, childSegment.length);
            char[] suffixSegment = Arrays.copyOfRange(segment, i, segment.length);
            Node replacingChild = new Node(commonPrefix, Maybe.nothing(), new TreeMap<Character, Node<V>>(CHAR_COMPARATOR), this);
            Node<V> grandChild1 = new Node<V>(suffixChildSegment, child.value, child.children, replacingChild);
            Node grandChild2 = new Node(suffixSegment, Maybe.nothing(), null, replacingChild);
            replacingChild.children.put(Character.valueOf(suffixChildSegment[0]), grandChild1);
            replacingChild.children.put(Character.valueOf(suffixSegment[0]), grandChild2);
            this.children.put(Character.valueOf(childKey), replacingChild);
            return grandChild2;
        }

        private int length() {
            return (this.parent == null ? 0 : super.length()) + this.segment.length;
        }

        private char[] fullString() {
            int last = this.length();
            char[] result = new char[last];
            Node<V> node = this;
            while (node != null) {
                char[] segment = node.segment;
                int segmentLength = segment.length;
                System.arraycopy(segment, 0, result, last - segmentLength, segmentLength);
                last -= segmentLength;
                node = node.parent;
            }
            return result;
        }

        private void traverse(BiConsumer<char[], ? super V> consumer) {
            if (this.value.isPresent()) {
                consumer.accept(this.fullString(), this.value.get());
            }
            if (this.children != null) {
                for (Node<V> child : this.children.values()) {
                    if (child == null) continue;
                    super.traverse(consumer);
                }
            }
        }
    }
}

