/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.clear;

import com.janboerman.invsee.utils.Compat;
import com.janboerman.invsee.utils.StringHelper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

class ClearTabCompleter
implements TabCompleter {
    ClearTabCompleter() {
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 0 || args[0].isEmpty()) {
            return null;
        }
        if (args.length == 1) {
            String inputName = args[0];
            Stream<Object> targets = sender.getServer().getOnlinePlayers().stream();
            if (sender instanceof Player) {
                Player player = (Player)sender;
                targets = targets.filter(arg_0 -> ((Player)player).canSee(arg_0));
            }
            return targets.map(Player::getName).filter(name -> StringHelper.startsWithIgnoreCase((String)name, (String)inputName)).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String inputMaterial = args[1].toLowerCase();
            Stream<String> materialNames = Arrays.stream(Material.values()).map(material -> material.name().toLowerCase());
            if (!inputMaterial.isEmpty()) {
                materialNames = materialNames.filter(name -> name.startsWith(inputMaterial));
            }
            return materialNames.collect(Collectors.toList());
        }
        if (args.length == 3) {
            String inputAmount = args[2];
            Material material2 = Material.matchMaterial((String)args[1]);
            Stream<String> amounts = IntStream.rangeClosed(1, material2 != null ? material2.getMaxStackSize() : 64).mapToObj(Integer::toString);
            if (!inputAmount.isEmpty()) {
                amounts = amounts.filter(amount -> amount.startsWith(inputAmount));
            }
            return amounts.collect(Collectors.toList());
        }
        return Compat.emptyList();
    }
}

