/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.clear;

import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

class RemoveUtil {
    private RemoveUtil() {
    }

    static int removeAtMost(Inventory inventory, Material material, int atMost) {
        int removed = 0;
        for (int i = 0; i < inventory.getSize() && atMost > 0; ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack == null || itemStack.getType() != material) continue;
            int stackAmount = itemStack.getAmount();
            int subtractAmount = Math.min(stackAmount, atMost);
            itemStack.setAmount(stackAmount - subtractAmount);
            inventory.setItem(i, itemStack);
            atMost -= subtractAmount;
            removed += subtractAmount;
        }
        return removed;
    }

    static int removeIfAtMost(Inventory inventory, Predicate<? super ItemStack> predicate, int atMost) {
        int removed = 0;
        for (int i = 0; i < inventory.getSize() && atMost > 0; ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack == null || !predicate.test((ItemStack)itemStack)) continue;
            int stackAmount = itemStack.getAmount();
            int subtractAmount = Math.min(stackAmount, atMost);
            itemStack.setAmount(stackAmount - subtractAmount);
            inventory.setItem(i, itemStack);
            atMost -= subtractAmount;
            removed += subtractAmount;
        }
        return removed;
    }

    static void removeIf(Inventory inventory, Predicate<? super ItemStack> predicate) {
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            ItemStack existingStack = inventory.getItem(slot);
            if (existingStack == null || !predicate.test((ItemStack)existingStack)) continue;
            inventory.clear(slot);
        }
    }
}

