/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.give;

import com.janboerman.invsee.spigot.addon.give.GivePlugin;
import com.janboerman.invsee.spigot.addon.give.ItemQueueManager;
import com.janboerman.invsee.spigot.addon.give.cmd.ArgParser;
import com.janboerman.invsee.spigot.addon.give.cmd.ArgType;
import com.janboerman.invsee.spigot.addon.give.common.GiveApi;
import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventory;
import com.janboerman.invsee.spigot.api.InvseeAPI;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.response.ImplementationFault;
import com.janboerman.invsee.spigot.api.response.NotCreatedReason;
import com.janboerman.invsee.spigot.api.response.OfflineSupportDisabled;
import com.janboerman.invsee.spigot.api.response.TargetDoesNotExist;
import com.janboerman.invsee.spigot.api.response.TargetHasExemptPermission;
import com.janboerman.invsee.spigot.api.response.UnknownTarget;
import com.janboerman.invsee.utils.Either;
import com.janboerman.invsee.utils.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;

class EnderGiveExecutor
implements CommandExecutor {
    private final GivePlugin plugin;
    private final InvseeAPI invseeApi;
    private final GiveApi giveApi;
    private final ItemQueueManager queueManager;

    EnderGiveExecutor(GivePlugin plugin, InvseeAPI invseeApi, GiveApi giveApi, ItemQueueManager queueManager) {
        this.plugin = plugin;
        this.invseeApi = invseeApi;
        this.giveApi = giveApi;
        this.queueManager = queueManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length < 2) {
            return false;
        }
        Optional<List<ArgType>> maybeFormat = ArgParser.determineFormat(args);
        if (!maybeFormat.isPresent()) {
            return false;
        }
        List<ArgType> format = maybeFormat.get();
        Map<ArgType, String> groupedArguments = ArgParser.splitArguments(format, args);
        String inputPlayer = groupedArguments.get((Object)ArgType.TARGET);
        Pair<CompletableFuture<Optional<UUID>>, CompletableFuture<Optional<String>>> futures = ArgParser.parseTarget(this.invseeApi, inputPlayer);
        CompletableFuture uuidFuture = (CompletableFuture)futures.getFirst();
        CompletableFuture userNameFuture = (CompletableFuture)futures.getSecond();
        Either<String, ItemStack> eitherStack = ArgParser.parseItem(this.giveApi, groupedArguments);
        if (eitherStack.isLeft()) {
            sender.sendMessage(ChatColor.RED + (String)eitherStack.getLeft());
            return true;
        }
        assert (eitherStack.isRight());
        ItemStack finalItems = (ItemStack)eitherStack.getRight();
        CreationOptions creationOptions = this.invseeApi.enderInventoryCreationOptions().withOfflinePlayerSupport(this.plugin.offlinePlayerSupport()).withUnknownPlayerSupport(this.plugin.unknownPlayerSupport()).withBypassExemptedPlayers(this.plugin.bypassExemptEndersee(sender));
        uuidFuture.thenCombineAsync((CompletionStage)userNameFuture, (optUuid, optName) -> {
            if (!optName.isPresent() || !optUuid.isPresent()) {
                sender.sendMessage(ChatColor.RED + "Unknown player: " + inputPlayer);
            } else {
                String userName = (String)optName.get();
                UUID uuid = (UUID)optUuid.get();
                CompletableFuture responseFuture = this.invseeApi.enderSpectatorInventory(uuid, userName, creationOptions);
                responseFuture.thenAcceptAsync(response -> {
                    if (response.isSuccess()) {
                        EnderSpectatorInventory inventory = (EnderSpectatorInventory)response.getInventory();
                        ItemStack originalItems = finalItems.clone();
                        HashMap map = inventory.addItem(new ItemStack[]{finalItems});
                        if (map.isEmpty()) {
                            if (this.plugin.getServer().getPlayer(uuid) == null) {
                                this.invseeApi.saveEnderChest(inventory).whenComplete((v, e) -> {
                                    if (e != null) {
                                        this.plugin.getLogger().log(Level.SEVERE, "Could not save inventory", (Throwable)e);
                                    }
                                });
                            }
                            sender.sendMessage(ChatColor.GREEN + "Added " + originalItems + " to " + userName + "'s enderchest!");
                        } else {
                            int remainder = ((ItemStack)map.get(0)).getAmount();
                            finalItems.setAmount(remainder);
                            if (this.plugin.queueRemainingItems()) {
                                sender.sendMessage(ChatColor.YELLOW + "Could not add the following items to the player's enderchest: " + finalItems + ", enqueuing..");
                                this.queueManager.enqueueEnderchest(uuid, this.plugin.savePartialInventories() ? finalItems : originalItems);
                            } else {
                                sender.sendMessage(ChatColor.RED + "Could not add the following items to the player's enderchest: " + finalItems);
                            }
                            if (this.plugin.getServer().getPlayer(uuid) == null && this.plugin.savePartialInventories()) {
                                this.invseeApi.saveEnderChest(inventory).whenComplete((v, e) -> {
                                    if (e != null) {
                                        this.plugin.getLogger().log(Level.SEVERE, "Could not save enderchest", (Throwable)e);
                                    }
                                });
                            }
                        }
                    } else {
                        NotCreatedReason reason = response.getReason();
                        if (reason instanceof TargetDoesNotExist) {
                            TargetDoesNotExist targetDoesNotExist = (TargetDoesNotExist)reason;
                            sender.sendMessage(ChatColor.RED + "Player " + targetDoesNotExist.getTarget() + " does not exist.");
                        } else if (reason instanceof UnknownTarget) {
                            UnknownTarget unknownTarget = (UnknownTarget)reason;
                            sender.sendMessage(ChatColor.RED + "Player " + unknownTarget.getTarget() + " has not logged onto the server yet.");
                        } else if (reason instanceof TargetHasExemptPermission) {
                            TargetHasExemptPermission targetHasExemptPermission = (TargetHasExemptPermission)reason;
                            sender.sendMessage(ChatColor.RED + "Player " + targetHasExemptPermission.getTarget() + " is exempted from being spectated.");
                        } else if (reason instanceof ImplementationFault) {
                            ImplementationFault implementationFault = (ImplementationFault)reason;
                            sender.sendMessage(ChatColor.RED + "An internal fault occurred when trying to load " + implementationFault.getTarget() + "'s enderchest.");
                        } else if (reason instanceof OfflineSupportDisabled) {
                            sender.sendMessage(ChatColor.RED + "Spectating offline players' enderchest is disabled.");
                        } else {
                            sender.sendMessage(ChatColor.RED + "Cannot give to " + inputPlayer + "'s enderchest for an unknown reason.");
                        }
                    }
                }, runnable -> this.invseeApi.getScheduler().executeSyncPlayer(uuid, runnable, null));
            }
            return null;
        }, arg_0 -> ((Scheduler)this.invseeApi.getScheduler()).executeSyncGlobal(arg_0));
        return true;
    }
}

